/*
 * Support for nbq functions.
 */

#include <stddef.h>
#include <sys/types.h>
#if defined(m68k)
#import "spl.h"
#else
#import <kernserv/machine/spl.h>
#endif
#include "nbq.h"
#include "netbuf.h"


/*
 * We keep these around for efficiency. 
 */

struct netbuf_item *empty_netbuf_items = NULL;
int num_empty_netbuf_items = 0;

/*
 * This procedure will fill up the empty_netbuf_items list
 * to ENB_HIGH_MARK.  It _MUST NOT_ be called at interrupt
 * priority.
 *
 */

void topoff_empty_netbuf_item_list(void *arg)
{
  struct netbuf_item *head, *tail, *tmp;
  int i, s, num;
  static int in = 0;

  if (in)
    return;
  in = 1;

  head = (struct netbuf_item *) kalloc (sizeof(struct netbuf_item));
  if (head == NULL)
    {
      printf("Warning: memory allocation failure at %s %d\n", __FILE__, __LINE__);
      return;
    }

  tail = head;
  num = ENB_HIGH_MARK - num_empty_netbuf_items - 1;

  for (i = num; i; --i)
    {
      tmp = (struct netbuf_item *) kalloc (sizeof(struct netbuf_item));
      if (tmp == NULL)
	{
	  printf("Warning: memory allocation failure at %s %d\n", __FILE__, __LINE__);
	  break;
	}
      
      tail->next = tmp;
      tail = tmp;
    }

/*
 * Now add the linked list to the system list.
 */

  s = splimp();
  tail->next = empty_netbuf_items;
  empty_netbuf_items = head;
  num_empty_netbuf_items += num;
  splx(s);

  in = 0;
}


/*
 * This will add the wrapper back to the
 * free list.  The caller must handle the
 * data portion correctly.  It always
 * succeeds.
 */

void release_wrapper(struct netbuf_item * wrap)
{
  if (num_empty_netbuf_items > ENB_MAX_MARK)
	kfree(wrap, sizeof (struct netbuf_item));
      else
	{
	  wrap->next = empty_netbuf_items;
	  empty_netbuf_items = wrap;
	  ++num_empty_netbuf_items;
	}
}
