#
#                                 bundle.make
#
# Inputs from Makefile.preamble or Makefile.postamble (no defaults):
#	OTHER_CFLAGS - Flags passed to compiler (in addition to -g, -O, etc.)
#	OTHER_LDFLAGS - Flags passed to ld (in addition to -ObjC, etc.)
#	OTHER_OFILES - Additional relocatables that may be linked in
#	OTHER_PRODUCT_DEPENDS - Other dependencies of this project
#	OTHER_SOURCEFILES - Other source files maintained by .pre/postamble
#	OTHER_GARBAGE - Additional files to be removed by make 'clean' 
#
#	DSTROOT - Virtual root directory prepended to $(INSTALLDIR)
#
# Inputs from Makefile.preamble:
#	PRECOMPS - Precompiled headers that should be built before compilation 
#	OTHER_INITIAL_TARGETS - Targets to be built before subprojects, etc.
#
# Inputs from Makefile.postamble (with defaults set by this file):
#	MAKEFILES - Makefiles this project depends on (default = Makefile)
#	DEFAULT_CFLAGS - Set of CFLAGS used in compiling (default set below)
#
# Inputs from Makefile (avoid setting these, ProjectBuilder controls them):
#	NAME - name of application
#	LANGUAGE - langage in which the project is written (default "English")
#	LOCAL_RESOURCES - localized resources (e.g. nib's, images) of project
#	GLOBAL_RESOURCES - non-localized resources of project
#
#	CLASSES - Class implementation files in project.
#	HFILES - Header files in project.
#	MFILES - Other Objective-C source files in project. 
#	CFILES - Other C source files in project. 
#	PSWFILES - .psw files in the project
#	PSWMFILES - .pswm files in the project
#	SUBPROJECTS - Subprojects of this project
#	BUNDLES - Bundle subprojects of this project
#	OTHERSRCS - Other miscellaneous sources of this project
#	OTHERLINKED - Source files not matching a standard source extention
#	OTHERLINKEDOFILES - Other relocatable files to (always) link in.
#
#	MAKEFILEDIR - Directory in which to find this generic set of Makefiles
#	INSTALLDIR - Directory app will be installed into by 'install' target
#
# Outputs to common.make:
#	OFILE_DIR
#	DERIVED_FILES
#	PRODUCT_ROOT (overloaded by command-line when this is not standalone)
#

OFILE_DIR = obj
DERIVED_FILES = $(NAME) $(OFILE_DIR)
BUNDLE_DIR = $(NAME).bproj
CFLAGS = -g -O -Wall
DEFAULT_CFLAGS = $(CFLAGS) $(OTHER_CFLAGS)

PRODUCT_ROOT = $(BUNDLE_DIR:.bproj=.bundle)
BUNDLE = $(NAME:.bproj=)

include $(MAKEFILEDIR)/common.make

# Rewrite various rules to simulate a 'debug' for the standalone case

.c.o:
	$(CC) $(DEFAULT_CFLAGS) -c $*.c -o $(OFILE_DIR)/$*.o
.m.o:
	$(CC) $(DEFAULT_CFLAGS) $(OBJCFLAGS) -c $*.m -o $(OFILE_DIR)/$*.o
.psw.o:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.c $*.psw
	$(CC) $(DEFAULT_CFLAGS) -c $*.c -o $(OFILE_DIR)/$*.o
.pswm.o:
	$(PSWRAP) $(PSWFLAGS) -a -h $*.h -o $*.m $*.pswm
	$(CC) $(DEFAULT_CFLAGS) $(OBJCFLAGS) -c $*.m -o $(OFILE_DIR)/$*.o



all:: project

project:: $(INITIAL_TARGETS) subcomponents resources $(PRODUCT_ROOT)/$(BUNDLE)
			
$(PRODUCT_ROOT):
	@$(MKDIRS) $(PRODUCT_ROOT)

$(PRODUCT_ROOT)/$(BUNDLE): $(PRODUCT_DEPENDS) $(PRODUCT_ROOT)
	@(if [ "`$(ECHO) $(OFILES) $(OTHER_OFILES) | wc -w`" != "       0" ] ; then \
	   $(ECHO) $(LD) -r $(BUNDLELDFLAGS) -o $(PRODUCT_ROOT)/$(BUNDLE) $(OFILES) $(OTHER_OFILES) ; \
	   $(LD) -r $(BUNDLELDFLAGS) -o $(PRODUCT_ROOT)/$(BUNDLE) $(OFILES) $(OTHER_OFILES) ; \
	   $(CHMOD) a+x $(PRODUCT_ROOT)/$(BUNDLE) ; \
	fi)

depend:: Makefile.dependencies $(SUBPROJECTS:.subproj=.depend) $(BUNDLES:.bproj=.depend)

$(DSTROOT)$(INSTALLDIR):
	$(MKDIRS) $(DSTROOT)$(INSTALLDIR)

before_install:: $(DSTROOT)$(INSTALLDIR)
	$(RM) -rf $(DSTROOT)$(INSTALLDIR)/$(PRODUCT_ROOT)

after_install::

install:: project before_install $(OTHER_INSTALL_DEPENDS)
	$(TAR) cf - $(PRODUCT_ROOT) | (cd $(DSTROOT)$(INSTALLDIR); $(TAR) xf -)
	@somebundles=no; \
	-$(CHOWN) -Rf $(INSTALL_AS_USER).$(INSTALL_AS_GROUP) \
		$(DSTROOT)$(INSTALLDIR)/$(PRODUCT_ROOT)
	-$(CHMOD) -Rf go-w $(DSTROOT)$(INSTALLDIR)/$(PRODUCT_ROOT)
	if [ "$(INSTALL_PERMISSIONS)" != "" ] ; then \
		$(CHMOD) -f $(INSTALL_PERMISSIONS) \
			$(DSTROOT)$(INSTALLDIR)/$(PRODUCT_ROOT)/$(BUNDLE); \
	fi
	@$(MAKE) after_install

help::
	@$(ECHO) 'The following targets are available:'
	@$(ECHO) 
	@$(ECHO) ' all        Makes the bundle target (below).  This is the default target.'
	@$(ECHO) 
	@$(ECHO) ' bundle     Compiles and links an optimized (and debuggable) version of the'
	@$(ECHO) '            bundle into $(NAME).bundle'
	@$(ECHO) 	
	@$(ECHO) ' depend     Generates an optional Makefile.dependencies file for every level'
	@$(ECHO) '            of the bundle to reflect the complete dependency graph'
	@$(ECHO) '            (including headers).'
	@$(ECHO) 
	@$(ECHO) ' install    Builds (if needed) and copies <BundleName>.bundle'
	@$(ECHO) '            into the installation directory, setting permissions'
	@$(ECHO) '            and owners as appropriate.'
	@$(ECHO) 	
	@$(ECHO) ' installsrc Installs the source files for the bundle into the directory'
	@$(ECHO) '            specified in the SRCROOT variable in a command-line argument.'
	@$(ECHO) '            Note: the target directory will be removed and recreated.'
	@$(ECHO) 
	@$(ECHO) ' clean      Removes all files in the bundle derived from previous builds.'
	@$(ECHO) 
	@$(ECHO) ' help       Lists these targets with their descriptions.'
	@$(ECHO) 
	@$(ECHO) 'For more details, see the comments in /NextDeveloper/Makefiles/app/*.make.'

