#
#                                  app.make
#
# Inputs from Makefile.preamble or Makefile.postamble (no defaults):
#	OTHER_CFLAGS - Flags passed to compiler (in addition to -g, -O, etc.)
#	OTHER_LDFLAGS - Flags passed to ld (in addition to -ObjC, etc.)
#	OTHER_OFILES - Additional relocatables that may be linked in
#	OTHER_LIBS - Libraries to link with when making app target
#	OTHER_DEBUG_LIBS - Libraries to link with when making debug target
#	OTHER_PROF_LIBS - Libraries to link with when making profile target
#	OTHER_JAPANESE_LIBS - 'app' libraries when $(JAPANESE) = "YES"
#	OTHER_JAPANESE_DEBUG_LIBS - 'debug' libraries when $(JAPANESE) = "YES"
#	OTHER_JAPANESE_PROF_LIBS - 'profile' libs when $(JAPANESE) = "YES"
#	OTHER_PRODUCT_DEPENDS - Other dependencies of this project
#	OTHER_EARLY_TARGETS - Built before building subprojects/bundles
#	OTHER_SOURCEFILES - Other source files maintained by .pre/postamble
#	OTHER_GARBAGE - Additional files to be removed by make 'clean' 
#
#	DSTROOT - Virtual root directory prepended to $(INSTALLDIR)
#
# Inputs from Makefile.preamble:
#	PRECOMPS - Precompiled headers that should be built before compilation 
#	OTHER_INITIAL_TARGETS - Targets to be built before subprojects, etc.
#
# Inputs from Makefile.postamble (with defaults set in common.make):
#	INSTALL_AS_USER - User to chown app to at installation (default root)
#	INSTALL_AS_GROUP - Grp to chgrp app to at installation (default wheel)
#	INSTALL_PERMISSIONS - If set, 'install' chmod's executable to this.
#	MAKEFILES - Makefiles this project depends on (default = Makefile)
#
#	RELOCATABLE_STRIP_OPTS - Opts to strip for bundles (default = -x -u)
#	DYLD_APP_STRIP_OPTS - Opts to strip for apps w/ bundles (def. = -A -n)
#	APP_STRIP_OPTS - Opts to strip for apps w/o bundles (no default, but
#          developers doing their own dynamic loading should set this to 
#          $(DYLD_APP_STRIP_OPTS)
#
# Inputs from Makefile (avoid setting these, ProjectBuilder controls them):
#	NAME - name of application
#	LANGUAGE - langage in which the project is written (default "English")
#	ENGLISH - boolean flag set iff $(LANGUAGE) = "English"
#	JAPANESE - boolean flag set iff $(LANGUAGE) = "Japanese"
#	LOCAL_RESOURCES - localized resources (e.g. nib's, images) of project
#	GLOBAL_RESOURCES - non-localized resources of project
#	PROJECTVERSION - version of ProjectBuilder that output Makefile
#	APPICON - application icon file
#	DOCICONS - dock icon files
#	ICONSECTIONS - Specifies icon sections when linking executable 
#
#	CLASSES - Class implementation files in project.
#	HFILES - Header files in project.
#	MFILES - Other Objective-C source files in project. 
#	CFILES - Other C source files in project. 
#	PSWFILES - .psw files in the project
#	PSWMFILES - .pswm files in the project
#	SUBPROJECTS - Subprojects of this project
#	BUNDLES - Bundle subprojects of this project
#	OTHERSRCS - Other miscellaneous sources of this project
#	OTHERLINKED - Source files not matching a standard source extention
#
#	LIBS - Libraries to link with when making app target
#	DEBUG_LIBS - Libraries to link with when making debug target
#	PROF_LIBS - Libraries to link with when making profile target
#	OTHERLINKEDOFILES - Other relocatable files to (always) link in.
#
#	MAKEFILEDIR - Directory in which to find this generic set of Makefiles
#	INSTALLDIR - Directory app will be installed into by 'install' target
#	INSTALLFLAGS - not used
#	SOURCEMODE - not used
#
# Outputs from this file to common.make:
#	OFILE_DIR
#
# 

APPICONFLAGS =  -sectcreate __ICON __header $(NAME).iconheader  \
		-segprot __ICON r r $(ICONSECTIONS)

ICONHEADER = $(NAME).iconheader

include $(MAKEFILEDIR)/common.make

all:: app

	
app::
	@($(MKDIRS) $(NAME).app ; \
	if [ "$(ENGLISH)" = "YES" -o "$(JAPANESE)" != "YES" ] ; then \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).app" \
		"PRODUCT = $(NAME).app/$(NAME)" \
		"OFILE_DIR=obj" \
		"CFLAGS =  -O -Wall $(CFLAGS) $(OTHER_CFLAGS)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	else \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).app" \
		"PRODUCT = $(NAME).app/$(NAME)" \
		"OFILE_DIR=obj" \
		"CFLAGS =  -O -Wall -DKANJI $(CFLAGS) $(OTHER_CFLAGS)" \
		"LIBS = $(LIBS:lNeXT_s=lNeXTJ_s)" \
		"OTHER_LIBS = $(OTHER_LIBS:lNeXT_s=lNeXTJ_s)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	fi )

debug::
	@($(MKDIRS) $(NAME).debug ; \
	if [ "$(ENGLISH)" = "YES" -o "$(JAPANESE)" != "YES" ] ; then \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).debug" \
		"PRODUCT = $(NAME).debug/$(NAME)" \
		"OFILE_DIR=debug_obj" \
		"CFLAGS =  -Wall -DDEBUG $(CFLAGS) $(OTHER_CFLAGS)" \
		"LIBS = $(DEBUG_LIBS)" "OTHER_LIBS = $(OTHER_DEBUG_LIBS)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	else \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).debug" \
		"PRODUCT = $(NAME).debug/$(NAME)" \
		"OFILE_DIR=debug_obj" \
		"CFLAGS =  -Wall -DDEBUG -DKANJI $(CFLAGS) $(OTHER_CFLAGS)" \
		"LIBS = $(DEBUG_LIBS:lNeXT_s=lNeXTJ_s)" \
		"OTHER_LIBS = $(OTHER_DEBUG_LIBS:lNeXT_s=lNeXTJ_s)" \
		"OTHER_JAPANESE_LIBS = $(OTHER_JAPANESE_DEBUG_LIBS)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	fi )

profile::
	@($(MKDIRS) $(NAME).profile ; \
	if [ "$(ENGLISH)" = "YES" -o "$(JAPANESE)" != "YES" ] ; then \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).profile" \
		"PRODUCT = $(NAME).profile/$(NAME)" \
		"OFILE_DIR=profile_obj" \
		"CFLAGS =  -pg -O -Wall -DPROFILE $(CFLAGS) $(OTHER_CFLAGS)" \
		"LIBS = $(PROF_LIBS)" "OTHER_LIBS = $(OTHER_PROF_LIBS)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	else \
	$(MAKE) project \
		"PRODUCT_ROOT = $(NAME).profile" \
		"PRODUCT = $(NAME).profile/$(NAME)" \
		"OFILE_DIR=profile_obj" \
		"CFLAGS =  -pg -O -Wall -DPROFILE -DKANJI $(CFLAGS) $(OTHER_CFLAGS)" \
		"LIBS = $(PROF_LIBS:lNeXT_s=lNeXTJ_s)" \
		"OTHER_LIBS = $(OTHER_PROF_LIBS:lNeXT_s=lNeXTJ_s)" \
		"OTHER_JAPANESE_LIBS = $(OTHER_JAPANESE_PROF_LIBS)" \
		"MAKEFILEDIR = $(MAKEFILEDIR)" ; \
	fi )



depend:: Makefile.dependencies $(SUBPROJECTS:.subproj=.depend) $(BUNDLES:.bproj=.depend)

# Note: The order of the following project dependencies is very important.  subcomponents must be after $(PROJECT_OFILES) in case a subcomponent relies upon something (e.g. generated .h file) at the top level, but all subprojects must be built (hopefully by one invocation of make in that subdirectory) before the $(PRODUCT) can be linked.

project::   $(INITIAL_TARGETS) subcomponents resources $(PRODUCT)
	-@($(RM) -f $(CHANGES_FILE) ; $(TOUCH) $(CHANGES_FILE))
	
$(PRODUCT): $(PRODUCT_DEPENDS) $(OTHER_PRODUCT_DEPENDS) 
	@(adaptors="" ; \
	for adaptor in $(OTHERRELOCATABLES) none ; do \
	    if [ $$adaptor = "none" ] ; then break; fi ; \
	    for path in $(ADAPTOR_SEARCH_PATH) none ; do \
	        if [ $$path = "none" ] ; then break; fi ;\
	    	if [ -r $$path/$$adaptor ] ; then \
		    adaptors="$$adaptors $$path/$$adaptor" ; \
		    break ; \
		fi ; \
	    done ; \
	done ; \
	if [ "$(PROJECTVERSION)" -lt "1" -o "$(PROJECTVERSION)" = "1.0" ] ; then \
	    if [ "$(ENGLISH)" = "YES" -o "$(JAPANESE)" != "YES" ] ; then \
	    $(ECHO) "$(CC) $(CFLAGS) $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_LIBS) $(LIBS)" ; \
	    $(CC) $(CFLAGS) $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_LIBS) $(LIBS) ; \
	    else \
	    $(ECHO) "$(CC) $(CFLAGS) $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_JAPANESE_LIBS) \
		    $(OTHER_LIBS) $(LIBS)" ; \
	    $(CC) $(CFLAGS) $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_JAPANESE_LIBS) \
		    $(OTHER_LIBS) $(LIBS) ; \
	    fi ; \
	else \
	    if [ "$(ENGLISH)" = "YES" -o "$(JAPANESE)" != "YES" ] ; then \
	    $(ECHO) "$(CC) $(CFLAGS) -ObjC $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_LIBS) $(LIBS)" ; \
	    $(CC) $(CFLAGS) -ObjC $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_LIBS) $(LIBS) ; \
	    else \
	    $(ECHO) "$(CC) $(CFLAGS) -ObjC $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_JAPANESE_LIBS) \
		    $(OTHER_LIBS) $(LIBS)" ; \
	    $(CC) $(CFLAGS) -ObjC $(LDFLAGS) $(OTHER_LDFLAGS) $(APPICONFLAGS) -o $(PRODUCT) \
		    $(OFILES) $(OTHER_OFILES) $$adaptors $(OTHER_JAPANESE_LIBS) \
		    $(OTHER_LIBS) $(LIBS) ; \
	    fi ; \
	fi)

$(DSTROOT)$(INSTALLDIR):
	$(MKDIRS) $(DSTROOT)$(INSTALLDIR)

before_install:: $(DSTROOT)$(INSTALLDIR)
	$(RM) -rf $(DSTROOT)$(INSTALLDIR)/$(NAME).app

after_install::

install:: app before_install $(OTHER_INSTALL_DEPENDS)
	$(TAR) cf - $(NAME).app | (cd $(DSTROOT)$(INSTALLDIR); $(TAR) xf -)
	@somebundles=no; \
	for i in $(BUNDLES:.bproj=) none ; do \
		if [ $$i = none ] ; then continue; fi; \
		somebundles=yes; \
		$(ECHO) /bin/cp -p -r $$i.bproj $(DSTROOT)$(INSTALLDIR)/$(NAME).app/$$i; \
		/bin/cp -p -r $$i.bproj $(DSTROOT)$(INSTALLDIR)/$(NAME).app/$$i; \
	done; \
	$(MAKE) after_install


help::
	@$(ECHO) 'The following targets are available:'
	@$(ECHO) 
	@$(ECHO) ' all        Makes the app target (below).  This is the default target.'
	@$(ECHO) 
	@$(ECHO) ' app        Compiles and links an optimized (and debuggable) version of the'
	@$(ECHO) '            project, ready to install, into <ProjectName>.app.'
	@$(ECHO)  	
	@$(ECHO) ' debug      Compiles (with all warnings and -DDEBUG on) and links a '
	@$(ECHO) '            fully-debuggable version of the project into a <ProjectName>.debug' 
	@$(ECHO) '            "app wrapper".'
	@$(ECHO) 
	@$(ECHO) ' profile    Compiles (with all warnings and -DPROFILE on) and links a'
	@$(ECHO) '            version of the project into <ProjectName>.profile.'
	@$(ECHO) '            "app wrapper" that will, when run, generate a gprof report.'
	@$(ECHO) 
	@$(ECHO) ' depend     Generates an optional Makefile.dependencies file for every level'
	@$(ECHO) '            of the project to reflect the complete dependency graph'
	@$(ECHO) '            (including headers).'
	@$(ECHO) 
	@$(ECHO) ' install    Builds (if needed) and copies <ProjectName>.app into the'
	@$(ECHO) '            installation directory, setting permissions and owners as'
	@$(ECHO) '            appropriate.'
	@$(ECHO) 
	@$(ECHO) ' installsrc Installs the source files for the project into the directory'
	@$(ECHO) '            specified in the SRCROOT variable in a command-line argument.'
	@$(ECHO) '            Note: the target directory will be removed and recreated.'
	@$(ECHO) 	   
	@$(ECHO) ' clean      Removes all files in the project derived from previous builds.'
	@$(ECHO)  
	@$(ECHO) ' help       Lists these targets with their descriptions.'
	@$(ECHO) 
	@$(ECHO) 'For more details, see the comments in /NextDeveloper/Makefiles/app/*.make.'
