/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <objc/Object.h>


@interface Utilities:Object
{

  // Outlet variables
  id toFreq;              // For phase inc to freq calculation 
  id toPhaseInc;          // For freq to phase inc calculation
  id theTableLength;      // Length of table used for an oscillator (usually 256)
  id theSrate;            // Sampling rate
  id theInspector;
  id theSP;               // The FakeSynthPatch
}
typedef int (*ptrToIntFcn)();

- sortList:(List *)aList sortFunction:(ptrToIntFcn) fcn;
- (BOOL) checkName: (char *) aName;
- (char *) getAppDir;
- displayInspector:sender;
- getPhaseIncrement:sender;
- getFrequency:sender;
- (char *) envelopeToText:anEnvelope;
- textToEnvelope: (char *) aString;
- (char *) getPathLeaf: (char *) path;
@end


