/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * UGArgSlider.h
 */

#import <appkit/appkit.h>

@interface UGArgSlider:Object
{
  id theFakeUG;              // The FakeUG that displayed this slider
  int theArgNum;             // The index of the argument
  int theArgType;            // The type of argument.  int or double for now
  id theArgField;            // The TextField from FakeUG.nib
  id theSlider;              // The slider itself
  id theMaxField;            // The max: TextField
  id theMinField;            // The min: TextField
  id theSliderValue;         // The TextField for the current value of the slider
  id inspector;              // The inspector panel
  NXRect inspectorRect;       // The rectangle the inspector is in
  BOOL inspectorRectJustLoaded;  // YES:  the inspectorRect was just read in
  BOOL useInspectorRect;      // YES:  use the inspectorRect that was just read in
  BOOL inspectorDisplayed;    // YES:  the inspector is being displayed
  BOOL doHighlight;
}

- init;
- closeInspector;
- initFromFakeUG: aFakeUG ArgNum:(int) argnum ArgField:aTextField ArgType:(int) type;
- updateInspectorTitle;
- setMaxVal:(double) val;
- setMinVal:(double) val;
- takeSliderValueFrom:aField;
- takeSliderMaxFrom:sender;
- takeSliderMinFrom:sender;
- pingUGInspector;
- dispatchSliderValue:sender;
- displayInspector;
@end


