/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/*
 * FakeSynthPatch.h
 * Eric Jordan, independent work, Spring, 1992
 * The screen as a whole corresponds to a fake synth patch.  We must
 * use a fake synth patch, instead of a real one as provided by the
 * music kit, because we must keep track of fake ug's, and the connections
 * between them, rather than actual ug's.
 */

#define DEBUG_PRINT printf
#import <objc/Object.h>
#import <objc/List.h>
#import <appkit/View.h>
#import <appkit/graphics.h>

#ifdef NEXT_2_0 
#import <nextdev/event.h>
#else
#import <dpsclient/event.h>
#endif

#import "NodeView.h"

double min(double a, double b);

double atod(STR s);

@interface FakeSynthPatch : View
{
  // Outlets that must be initialized at init or load time
  id theController;          // The bawana
  id utilities;              // Object that has utility methods
  id memory;                 // if 1: x memory else y memory
  id midiPortSwitch;         // tag 1: Serial port 1  tag 2: Serial port 2
  id soundOutDeviceSwitch;   // Switch that says what type of device sound out goes to
  id samplingRateSwitch;     // Switch that says what sampling rate to use
  id defaultArgValSwitch;    // Switch that says whether to read UG or use defaults
  id allocOnOpenSwitch;      // Switch that says whether to alloc the patch on open
  id alwaysUpdateSwitch;     // Switch that says whether or not to always allow inspector updates
                             // If enabled, midi response will be slower, but you'll see 
                             // the numbers change on the inspectors
  id noteOnButton;
  id noteOffButton;
  id stopButton;
  id resetControl;           // Reset menu item
  id closeAllControl;        // Close all menu item
  id displayAllControl;      // Display all menu item
  id printSelfControl;       // Print theSP on admin menu

  // Internal objects
  id fakeUGs;                // a list of the unit generators
  id fakePatchPoints;        // a list of the patch points.
  NodeView *fromNode;        // the first node in a pair of nodes being connected
  id selected;               // The object that is currently selected.
  id orch;
  id serialPortDevice;
  id midi;                   // An instance of the Midi object
  id midiNoteOnHandler;

  // Internal variables
  int soundOutDevice;        // NeXT internal DAC's = 0, DSP serial port = 1
  int midiPort;              // Port number midi is on  -- 0 or 1
  double samplingRate;       // Sampling rate Orchestra uses
  char *name;                // The name of this synth patch
  BOOL serialPortSoundIn;
  BOOL serialPortSoundOut;
  BOOL haveMidi;
  BOOL midiRunning;
  BOOL midiDidInit;
  BOOL noteOffEnabled;       // YES:  Enable sending of noteOff
  BOOL inputWarningDone;     // YES:  Don't tell the user their is a serial out device
  BOOL outputWarningDone;    // YES:  Don't tell the user their is a serial out device
  BOOL needsAllocation;      // YES:  Allocate the patch before sending first NoteOn
  BOOL windowMiniaturized;   // YES:  The window is hidden, don't bother with highlighting
  BOOL phraseInProgress;     // For noteOn/noteOff/noteEnd mechanism
  BOOL allowPPInspectorUpdate;   // YES:  Allow PatchParameters to update inspectors
  BOOL alwaysUpdate;         // YES:  Allow update inspectors regardless of allowPPInspectorUpdate
}

+initialize;

- init;

- setWindowMiniaturized:(BOOL) flag;

- (BOOL) windowMiniaturized;

- setController: aController;

- theController;

- setWindowDelegate: aDelegate;

- windowDelegate;

- setMemory: aMemory;

- setUtilities: aUtilities;

- setMidiPortSwitch: aMidiPortSwitch;

- setSoundOutDeviceSwitch: aSoundOutDeviceSwitch;

- setSamplingRateSwitch: aSamplingRateSwitch;

- setDefaultArgValSwitch: aSwitch;

- setAllocOnOpenSwitch: aSwitch;

- setAlwaysUpdateSwitch: aSwitch;

- setNoteOnButton: aNoteOnButton;

- setNoteOffButton: aNoteOffButton;

- setStopButton: aStopButton;

- setResetControl: aResetControl;

- setCloseAllControl: aCloseAllControl;

- setDisplayAllControl: aDisplayAllControl;

- setPrintSelfControl: aPrintSelfControl;

- setOrch:anOrch;

- memory;

- utilities;

- midiPortSwitch;

- soundOutDeviceSwitch;

- samplingRateSwitch;

- defaultArgValSwitch;

- allocOnOpenSwitch;

- alwaysUpdateSwitch;

- noteOnButton;

- noteOffButton;

- stopButton;

- resetControl;

- closeAllControl;

- closeAll:sender;

- displayAllControl;

- displayAll:sender;

- printSelfControl;

- updateSamplingRateSwitch;

- updateSoundOutDeviceSwitch;

- updateMidiPortSwitch;

- (BOOL) useDefaultArgValues;

- (BOOL) allocOnOpen;

- setAlwaysUpdate:sender;

- (BOOL) alwaysUpdate;

- (double) samplingRate;

- (int) soundOutDevice;

- (int) getMidiPortFromSwitch;

- (int) midiPort;

- getFakeUGs;

- addFakeUG: anDef at:(NXPoint)location;

- setFrom:(NodeView *) newFromNode;
/* Set the from node in the next pair of unit generators 
 * to be connected to make a patch point.
 */
 
- connect:(NodeView *)toNode;
/* Connect the two unit generators, making a new patch point. */

- makeSelected:anObject;

- setSelected:sender;
/* Set the sender to be the currently selected one. */

- getSelected;
/* Return the currently selected object. */

- setNameOfSelectedObject:sender; 
/* change the name of the currently selected object. */

- cut:sender;

- delete:sender;

- remFakeUGFromList:fakeUG;

- remFakePatchPointFromList:fakePatchPoint;

- removeSelf;

- (char *)getName;

- changeName:(char *)newName;

- (char *)getTypeString;

- (BOOL)getXMemory;

- (BOOL)isAFakeUG;

- setUGParameterFromFakeUG:aFakeUG argNum:(int)j;

- getOrch;

- claimDSP:sender;

- releaseDSP:sender;

- allocatePatch;

- syncUGArgs;

- deallocatePatch:sender;

- noteOn:sender;

- noteOff:sender;

- noteEnd;

- checkDSPSerialPorts;

- enableNoteOff:(BOOL) flag;

- (BOOL) noteOffEnabled;

- setAllowPPInspectorUpdate:(BOOL) flag;

- (BOOL) allowPPInspectorUpdate;

- eraseSelf;

- (BOOL)acceptsFirstMouse;

- mouseDown:(NXEvent *)theEvent;

- getFakePatchPoints;

- setSerialIn:(BOOL)state;

- setSerialOut:(BOOL)state;

- initMidi;

- initMidiNoteOnHandler;

- startMidi;

- restartMidi:sender;

- setHaveMidi:(BOOL) flag;

- (BOOL) haveMidi;

- freeMidi;

- midiNoteOnHandler;

- midi;

- conductor;

- (BOOL) hasSoundMakers;

- (BOOL) hasControllableSoundMakers;

- updateElements;

- printSelf:sender;

- sortFakePatchPointsByAllocOrder;

- sortFakeUGsByAllocOrder;

- write:(NXTypedStream *)stream;

- read:(NXTypedStream *)stream;

@end

