/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#define DEBUG_PRINT printf
/*
 * FakePatchPoint.h
 * Eric Jordan, independent work, Spring, 1992
 * Each connection between icons on the screen corresponds to a "fake
 * patch point".
 * We must use a fake patch point, instead of a real one as provided
 * by the music kit, in order to relate fake unit generators (as opposed
 * to real unit generators), and to retain the ability to recall what 
 * connections have been made. 
 */

#import <appkit/graphics.h>

#ifdef NEXT_2_0 
#import <nextdev/event.h>
#else
#import <dpsclient/event.h>
#endif

#import <dpsclient/psops.h>
#import <appkit/View.h>
#import <appkit/Panel.h>
#import <objc/List.h>
#import "NodeView.h"
#import "FakeUG.h"

#define LINEWIDTH 2.0

#define MAXPATCHPOINTNAMELENGTH 20

@interface FakePatchPoint : View
{
  char theName[256];
  NodeView *fromNode;
  /* We maintain a list of tonodes. */
  id toNode;
  BOOL xmemory;
  /* The actual patch point, used to make a sound here and now. */
  id pp;
  BOOL isAllocated;
  id inspector;
  id ppNameField;
  id fromInfo;                      // Field that shows info on the fromNode
  id toInfo;                        // Field that shows info on the toNodes
  id theSP;
  int allocOrder;                   // The order the PatchPoint is allocated
  id allocOrderField;               // Field on the inspector for allocOrder
  int clickCount;                   // Number of times an instance has been clicked
  NXRect inspectorRect;                         // The rectangle the inspector is in
  BOOL inspectorRectJustLoaded;                 // YES:  the inspectorRect was just read in
  BOOL useInspectorRect;                        // YES:  use the inspectorRect that was just read in
  BOOL inspectorDisplayed;                      // YES:  the inspector is being displayed
  BOOL doHighlight;
  BOOL midiConnected;

}

/* 
 * This is really part of the initialization process, but we want to pass it
 * some arguments, so it is its own method.
 */
- init;

- setSP:aSP;

- closeInspector;

- setName:(char *) aName;

- takeAllocOrderFrom:sender;

- setAllocOrder:(int) order;

- (int) getAllocOrder;

- updateAllocOrder;

- displayInspector;

- displayInspectorIfWasActive;

- updateInfo;

- inspectorClosed;

- setInspectorName:(char *) aName;

- validate;

- connect:fromNode to:toNode xmemory:(BOOL)mem;

- checkMidiFrom:aFromFakeUG To:aToFakeUG;

- (FakeUG *)getFromFakeUG;

- (int)getFromConnectionNumber;

- getFromNode;

- getToNodes;

- (BOOL)getXMemory;

- getpp;

- (char *)getName;

- takeNameFromInspector:sender;

- (char *)getTypeString;

- (BOOL)isAFakeUG;

- (BOOL)isAFakePatchPoint;

- (BOOL)isPatchParameter;

- (BOOL)isClavier;

- (BOOL)isMidi;

- allocatePPMK;

- deallocPPMK;

- makeConnectionsMK;

- eraseSelf;

- drawSelf:(const NXRect *)rects :(int)rectCount;

- write:(NXTypedStream *) stream;

- read:(NXTypedStream *) stream;

- printSelf;

- displayIfDoubleClick;

- highlightSelf;
@end
