/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

/* EnvelopeView.h -- Interface for EnvelopeView class
*/

#import <appkit/View.h>
#import "UserPath.h"

@interface EnvelopeView : View
{
	id theController;			// object which controls the envelope view
	id theEnvelope;				// the envelope object being viewed
	id theCross;				// crosshairs cursor
	id theFilledCross;			// crosshairs plus knob cursor
	
	int selected;				// current highlighted point in envelope
        float defaultSmooth;                    // default smoothing read from the defaults database
	float envColour;			// colour to draw envelope with
	
	float xMax;					// coordinate system limits
	float xMin;
	float yMax;
	float yMin;
	
	float xSnap;				// Snap increments
	float ySnap;
	
    UserPath *userPath;			// user path for drawing segments
	
	int showSmooth;				// show or not smoothing in envelopes
	int drawSegments;				// draw or not segments between points
}

- allocateTemp:(int) size;
- freeTemp;
- allocateDraw:(int) size;
- freeDraw;
- envelope; 
- setNewEnvelope:anEnv;
- resetCursorRects;
- initFrame:(const NXRect *)frameRect;
- controllerIs:sender;
- drawSelf:(NXRect *)rects :(int)rectCount;
- (int) hitKnobAt:(NXPoint)p border:(float)delta;
- (int) movePoint:(int)n to: (NXPoint)p;
- mouseDown:(NXEvent *)event;

- highlight;
- dim;
- (BOOL) acceptsFirstResponder;
- becomeFirstResponder;
- resignFirstResponder;

- copy:id;
- paste:id;

- setPointTo: (int)i;
- nextPoint;
- previousPoint;
- setXAt: (int)point to: (float)coord;
- setYAt: (int)point to: (float)coord;
- setYrAt: (int)point to: (float)coord;
- setSmoothAt: (int)point to: (float)val;
- setXMinTo: (float)coord;
- setXMaxTo: (float)coord;
- setXLimitsTo: (float)min : (float)max;
- setYMinTo: (float)coord;
- setYMaxTo: (float)coord;
- setXSnapTo: (float)coord;
- setYSnapTo: (float)coord;
- setStickyAt:(int)point To:(int) state;
- setShowSmooth: (int)state;
- setDrawSegments: (int)state;
- scaleLimits;
- (int)getPoint;
- (float)getX:(int)i;
- (float)getY:(int)i;
- (float)getYr:(int)i;
- (float)getSmoothing:(int)i;
- (int)getSticky:(int)i;
- (float)getXMax;
- (float)getXMin;
- (float)getYMax;
- (float)getYMin;
- (float)getXSnap;
- (float)getYSnap;
- (int)getShowSmooth;
- (int)getDrawSegments;

@end
