/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <objc/Object.h>
#import <objc/List.h>

@interface ElementController:Object
{
  List *theUGList;
  List *theNGList;
  List *theNFList;
  id theController;         // Connected in the nib
  id theViewController;     // The thing that deals with the scrolling list
  id addNameLabel;
  id addPanel;
  id theDragView;           // the icon well where elements get placed
  id theMultiView;          // View that switches between ug/nf/ng's
  id utilities;             // Utilities object
}

- awakeFromNib;

- init;

- switchView:sender;

- displayInspector:sender;

- readStandardDefs;

- readStandardUGDefs:sender;

- readStandardNFDefs:sender;

- readStandardNGDefs:sender;

- setUGList: aUGList;

- setNGList: aNGList;

- setNFList: aNFList;

- getUGList;

- getNGList;

- getNFList;

- initViews;

- initUGView;

- initNFView;

- initNGView;

- buildStandardUGDefs;

- oldUGTypeToUGDef: (int) old_index;

- writeUGDefs:sender;

- writeNFDefs:sender;

- writeNGDefs:sender;

- writeDefsFrom: aList To:(char *) aFile;

- readUGDefsFromMenu:sender;

- readNGDefsFromMenu:sender;

- readNFDefsFromMenu:sender;

- readUGDefs:(char *) file;

- readNGDefs:(char *) file;

- readNFDefs:(char *) file;

- (List *) readDefsFrom: (char *) file;

@end
