/**************************************************
 * SynthBuilder
 * Copyright 1993 Nick Porcaro All Rights Reserved
 **************************************************/

#import <stdlib.h>
#import <appkit/Matrix.h>
#import <appkit/Panel.h>
#import <dpsclient/psops.h>
#import <dpsclient/wraps.h>
#import "ViewController.h"
#import "DragView.h"
#import "FakeSynthPatch.h"

@implementation DragView

+initialize
{
  return self;
}

- init
{
  [super init];
  theImage = nil;
  return self;
}

- setPatch:aPatch
{
  thePatch = aPatch;
  return self;
}

- getPatch
{
  return thePatch;
}

- setViewController:aVC
{
  theViewController = aVC;
  return self;
}

- showImage:anImage
{
  NXRect *rect;
  NXPoint *thePoint;

  rect = (NXRect *) NXZoneMalloc([self zone], sizeof (*rect));
  if (anImage)
    {
      theImage = anImage;
    }
  else
    {
      return self;
    }

  if (! [theViewController getFocusLock])
    {
      return self;
    }

  [self lockFocus];
  rect->origin.x = frame.origin.x;
  rect->origin.y = frame.origin.y;
  rect->size.width = frame.size.width;
  rect->size.height = frame.size.height;
  [self convertRectFromSuperview:rect];
  PSsetgray(NX_LTGRAY);
  NXRectFill(rect);
  thePoint = (NXPoint *) NXZoneMalloc([self zone], sizeof (*thePoint));
  thePoint->x = thePoint->y = 0.0;
  [theImage composite:NX_SOVER toPoint:thePoint];
  NXPing();

  [self unlockFocus];
  return self;
}

- blank
{
  NXRect rect[1];

  if (! [theViewController getFocusLock])
    {
      return self;
    }

  [self lockFocus];
  rect->origin.x = frame.origin.x;
  rect->origin.y = frame.origin.y;
  rect->size.width = frame.size.width;
  rect->size.height = frame.size.height;
  [self convertRectFromSuperview:rect];
  PSsetgray(NX_LTGRAY);
  NXRectFill(rect);
  NXPing();
  [self unlockFocus];

  return self;
}

- drawSelf:(const NXRect *)rects :(int)rectCount
{
  return self;
}

- mouseDown:(NXEvent *)theEvent
{
  if (theImage)
    {
      [window addToEventMask:NX_LMOUSEDRAGGEDMASK];
      whereGrabbed = theEvent->location;
      [self convertPoint:&whereGrabbed fromView:nil];
    }

  return self;
}

- mouseDragged:(NXEvent *)theEvent
{
  NXPoint thePoint;

  if (!theImage)
    {
      return self;
    }

  [superview lockFocus];
  PSnewinstance();
  PSsetinstance(YES);
  thePoint.x = theEvent->location.x-whereGrabbed.x;
  thePoint.y = theEvent->location.y-whereGrabbed.y;
  [theImage composite:NX_SOVER toPoint:&thePoint];
  PSsetinstance(NO);
  [superview unlockFocus];
  return self;
}

- mouseUp:(NXEvent *)theEvent
{
  NXPoint thePoint;

  /* Disallow adding new elements when the
   * sound is on
   */
  if (!theImage)
    {
      return self;
    }

  if ([thePatch hitTest:&theEvent->location])
    {
      thePoint.x = theEvent->location.x;
      thePoint.y = theEvent->location.y;
      thePoint.x = thePoint.x-whereGrabbed.x+1;
      thePoint.y = thePoint.y-whereGrabbed.y+1;
      [thePatch deallocatePatch:self];
      [thePatch convertPoint:&thePoint fromView:nil];
      [window removeFromEventMask:NX_LMOUSEDRAGGEDMASK];
      [thePatch addFakeUG:[theViewController currentObject] at:thePoint];
    }

  PSnewinstance();
  return self;
}

@end

