/* TrackerPlayerPrivate.h */
/* Generated by myself! */

/* DO_NOTHING is also used for the automaton */
#define DO_NOTHING	0
#define PLAY				1
#define REPLAY			2
     
#define MAX_ARP			3
     
/* there is no note in each channel initially.
 * This is defensive programming, because some
 * commands rely on the previous note. Checking
 * that there was no previous note is a way to
 * detect faulty modules.
 */
#define NO_NOTE 255

struct channel
{
	struct sample_info *samp;
	int mode;               /* automaton state for the sound generatio */
	unsigned int pointer;   /* current sample position (fixed pos) */
	unsigned int step;      /* sample position increment (gives pitch) */
	int volume;             /* current volume of the sample (0-64) */
	int pitch;              /* current pitch of the sample */
	int note;               /* we have to save the note cause */
													/* we can do an arpeggio without a new note */
	
	int arp[MAX_ARP];       /* the three pitch values for an arpeggio */
	int arpindex;           /* an index to know which note the arpeggio is doing
														*/

	int viboffset;          /* current offset for vibrato (if any) */
	int vibdepth;           /* depth of vibrato (if any) */

	int slide;              /* step size of pitch slide */

	int pitchgoal;          /* pitch to slide to */
	int pitchrate;          /* step rate for portamento */

	int volumerate;         /* step rate for volume slide */

	int vibrate;            /* step rate for vibrato */
	void (*adjust)();       /* current command to adjust parameters */
};

#define SET_SPEED			1
#define SET_SKIP			2
#define SET_FASTSKIP	4

#define NORMAL_SPEED			6
#define NORMAL_FINESPEED	100

struct automaton
{
	int pattern_num;            /* the pattern in the song */
	int note_num;               /* the note in the pattern */
	struct block *pattern;      /* the physical pattern */
	struct song_info *info;     /* we need the song_info */
	
	int counter;                /* the fine position inside the effect */
	int speed;                  /* the `speed', number of effect repeats */
	int finespeed;              /* the finespeed, base is 100 */
	
	int do_stuff;               /* keeping some stuff to do */
															/* ... and parameters for it: */
	int new_speed, new_note, new_pattern, new_fastspeed;
	
	int pitch, note, para;      /* some extra parameters effects need */
};

// extern.h:
/* error types. Everything is centralized,
 * and we check in some places (see read, player and str32)
 * that there was no error. Additionnally signal traps work
 * that way too.
 */
 
#define NONE 						0	/* normal state */
#define FILE_TOO_SHORT	1	/* read error */
#define CORRUPT_FILE		2
#define NEXT_SONG				3	/* trap error: goto next song right now */
#define FAULT						4	/* run time problem */
#define ENDED						5	/* the song has ended */
#define UNRECOVERABLE		6	/* unrecoverable problem: typically */
#define SAMPLE_FAULT		7	/* Missing sample. Very common error */
#define SUSPEND_SONG		8

#define ACCURACY 16
#define fix_to_int(x) ((x) >> ACCURACY)
#define int_to_fix(x) ((x) << ACCURACY)


/* some definitions for being able to read song.h */
#define OLD		0
#define NEW		1
#define BOTH	2					/* try both formats */
#define NEW_NO_CHECK 3	/* Assume new format without checking */

#define NUMBER_NOTES 120
#define neuMIN(A,B) ((A)<(B) ? (A) : (B))
#define neuMAX(A,B) ((A)>(B) ? (A) : (B))
#define D fprintf(stderr, "%d\n", __LINE__);

#define HZ 8000

typedef signed char SAMPLE;

struct pref
{
	int type, speed, tolerate, repeats;
};

// song.h
#define NUMBER_SAMPLES	32

#define BLOCK_LENGTH		64
#define NUMBER_TRACKS		4
#define NUMBER_PATTERNS	128

#define NUMBER_EFFECTS	16

#define MIN_PITCH				113
#define MAX_PITCH				1023

#define MIN_VOLUME			0
#define MAX_VOLUME			64

/* the fuzz in note pitch */
#define FUZZ 2

/* we refuse to allocate more than 500000 bytes for one sample */
#define MAX_SAMPLE_LENGTH 500000

struct sample_info
{
	char *name;
	int  length, rp_offset, rp_length;
	int volume;
	int finetune;
	SAMPLE *start, *rp_start;
};

/* the actual parameters may be split in two halves occasionnally */

#define LOW(para) ((para) & 15)
#define HI(para) ((para) >> 4)

struct event
{
	unsigned char sample_number;
	unsigned char effect;
	unsigned char parameters;
	unsigned char note;
	int pitch;
};

struct block
{
	struct event e[NUMBER_TRACKS][BLOCK_LENGTH];
};
    
        
struct song_info
{
	int length;
	int maxpat;
	char patnumber[NUMBER_PATTERNS];
	struct block *pblocks;
};

struct song
{
	char *title;
	/* sample 0 is always a dummy sample */
	struct sample_info *samples[NUMBER_SAMPLES];
	struct song_info *info;
};

/* Prototypes */
// audio.c
void create_step_table(int oversample);
void create_notes_table(void);
void init_tables(int oversample);
void resample(struct channel *chan, int oversample, int number);
void reset_note(struct channel *ch, int note, int pitch);
void set_current_pitch(struct channel *ch, int pitch);

// automaton.c
void set_pattern(struct automaton *a);
void init_automaton(struct automaton *a, struct song *song);
void advance_pattern(struct automaton *a);
void next_tick(struct automaton *a);

// commands.c
void do_nothing(struct channel *ch);
void set_nothing(struct automaton *a, struct channel *ch);
void do_slide(struct channel *ch);
void set_upslide(struct automaton *a, struct channel *ch);
void set_downslide(struct automaton *a, struct channel *ch);
void do_vibrato(struct channel *ch);
void set_vibrato(struct automaton *a, struct channel *ch);
void do_arpeggio(struct channel *ch);
void set_arpeggio(struct automaton *a, struct channel *ch);
void do_slidevol(struct channel *ch);
void parse_slidevol(struct channel *ch, int para);
void set_slidevol(struct automaton *a, struct channel *ch);
void do_portamento(struct channel *ch);
void set_portamento(struct automaton *a, struct channel *ch);
void do_portaslide(struct channel *ch);
void set_portaslide(struct automaton *a, struct channel *ch);
void do_vibratoslide(struct channel *ch);
void set_vibratoslide(struct automaton *a, struct channel *ch);
void set_speed(struct automaton *a, struct channel *ch);
void set_skip(struct automaton *a, struct channel *ch);
void set_fastskip(struct automaton *a, struct channel *ch);
void set_offset(struct automaton *a, struct channel *ch);
void set_volume(struct automaton *a, struct channel *ch);
void init_effects(void (*table[])());

// player.c
void init_channel(struct channel *ch, struct sample_info *dummy);
void init_player(int o, int f);
void setup_effect(struct channel *ch, struct automaton *a, struct event *e);
void play_song(struct song *song, struct pref *pref, int oversample);

// read.c
int find_note(int pitch);
int checkgetc(void);
char *getstring(int len);
void byteskip(int len);
int getushort(void);
void fill_sample_info(struct sample_info *info);
void fill_song_info(struct song_info *info);
void fill_event(struct event *e);
void fill_pattern(struct block *pattern);
void read_sample(struct sample_info *info);
struct song *new_song(void);
struct sample_info *new_sample_info(void);
struct song_info *new_song_info(void);
void release_song(struct song *song);
struct song *error_song(struct song *song);
int bad_sig(void);
struct song *read_song(int type, int tr);

// str32.c
void module_abspielen(char *buffer);

// next_audio.c
int open_audio(TrackerPlayer *);
void set_mix(int percent);
void output_samples(int left, int right, char last_sample);
void flush_buffer(int really_flush);
void close_audio(void);




