// Programm.m
// By Jayson Adams, NeXT Developer Support Team
// You may freely copy, distribute and reuse the code in this example.
// NeXT disclaims any warranty of any kind, expressed or implied, as to its
// fitness for any particular use.

// nderungen fr ModPlayer von Matthias Zepf, 1992

#import "Programm.h"

@implementation Programm:Object

- init:sender
{
	NXRect winFrame;

	MeineHerkunft = sender;
	if(!MeinPrgNib)
		MeinPrgNib = [NXApp loadNibLanguageFile:"Programm.nib"
			owner:self withNames:NO];
  [self createScrollingMatrix];
	[MeinPrgPanel getFrame:&winFrame];
	Breite = winFrame.size.width;
	Hoehe  = winFrame.size.height;
	AnzahlMatrixFelder = 0;
  return self;
}

- windowWillResize:sender toSize:(NXSize *)frameSize
{
	if(frameSize->width < Breite)
		frameSize->width = Breite;
	if(frameSize->height < Hoehe)
		frameSize->height = Hoehe;
	return self;
}

- createScrollingMatrix
{
	NXRect	scrollRect, matrixRect;
	NXSize	interCellSpacing = {0.0, 0.0}, cellSize;
    
	[MeinScrollView setBorderType:NX_BEZEL];
	[MeinScrollView setVertScrollerRequired:YES];
	[MeinScrollView setHorizScrollerRequired:NO];
	[MeinScrollView getFrame:&scrollRect];

	[ScrollView getContentSize:&(matrixRect.size)
		forFrameSize:&(scrollRect.size)
		horizScroller:NO
		vertScroller:YES
		borderType:NX_BEZEL];
    
	MeineMatrix = [[NiftyMatrix alloc] initFrame:&matrixRect
		mode:NX_LISTMODE
		cellClass:[CustomCell class]
		numRows:0
		numCols:1];

	[MeineMatrix setIntercell:&interCellSpacing];
	[MeineMatrix getCellSize:&cellSize];
	cellSize.width = NX_WIDTH(&matrixRect);
	[MeineMatrix setCellSize:&cellSize];
	[MeineMatrix sizeToCells];
	[MeineMatrix setAutosizeCells:YES];
	[MeineMatrix setAutoscroll:YES];
	[MeinScrollView setDocView:MeineMatrix];
	[[MeineMatrix superview] setAutoresizeSubviews:YES];
	[MeineMatrix setAutosizing:NX_WIDTHSIZABLE];
	[MeineMatrix setTarget:self];
    
	return self;
}

- (BOOL)multipleCellsSelected
{
  /* reset the counter */
    selectedCount = 0;
    
  /* get each selected cell to send the incrementCount method to us */
    [MeineMatrix sendAction:@selector(incrementCount:) to:self forAllCells:NO];
    
  /* if more than one, return true */
    return (selectedCount > 1);
}

- (BOOL)incrementCount:sender
{
  /*
   * once the counter reaches two, we know that more than one cell's
   * selected;  if that's the case, return NO so that the matrix will
   * discontinue having selected cells send incrementCount: to us
   */
    
    return (++selectedCount < 2);
}

- zeigeProgrammFenster:sender
{
	[MeinPrgPanel makeKeyAndOrderFront:self];
	return self;
}

- mischenKlick:sender
{
	int		i, r;
	long	z;
	id		zelle;
	
	if (AnzahlMatrixFelder > 1)
	{
		for (i = 0; i < AnzahlMatrixFelder - 1; i++)
		{
			z = random() % (long) (AnzahlMatrixFelder - i);
			r = (int) z + i;
			zelle = [MeineMatrix cellAt:r:0];
			zelle = [MeineMatrix putCell:zelle at:i:0];
			zelle = [MeineMatrix putCell:zelle at:r:0];
		}
		[MeineMatrix nummernAendern];
		[MeineMatrix update];
	}
	return self;
}

- hinzufuegenKlick:sender
{
	const		char *const suffix[] = {"mod", "pp", "MOD", "PP", NULL};
	const		char *const *modname;
	char		pfad[4096];
  id			newCell;
	id			openPanel;
	NXSize	cellSize;
  NXRect	matrixRect, scrollRect;

	openPanel = [OpenPanel new];
	[openPanel setTitle:[MeineStringTab valueForStringKey:"ladenMod"]];
	[openPanel allowMultipleFiles:YES];
	
	if ([openPanel runModalForDirectory:[MeineHerkunft GibStdPfad]
				file:NULL types:suffix]	&&
				(modname = [openPanel filenames]) != NULL)
	{
		while (*modname != NULL)
		{
			strcpy(pfad, [openPanel directory]);
			strcat(pfad, "/");
			strcat(pfad, *modname);
			[MeineMatrix addRow];
			newCell = [MeineMatrix cellAt:AnzahlMatrixFelder :0];
			[newCell setTag:(AnzahlMatrixFelder + 1)];
			[newCell setStringValue:pfad];
			AnzahlMatrixFelder++;
			modname++;
		}
	
		[MeinScrollView getFrame:&scrollRect];
		[ScrollView getContentSize:&(matrixRect.size)
				forFrameSize:&(scrollRect.size)
		horizScroller:NO
		vertScroller:YES
		borderType:NX_BEZEL];
	
		[MeineMatrix getCellSize:&cellSize];
		cellSize.width = NX_WIDTH(&matrixRect);
		[MeineMatrix setCellSize:&cellSize];
		[MeineMatrix sizeToCells];
		[MeineMatrix setAutosizeCells:YES];
	
		[MeinScrollView update];
	}
	return self;
}

- (BOOL) entfernen:zelle
{
	int r, c;
	
	if ([MeineMatrix getRow: &r andCol: &c ofCell: zelle])
	{
		[zelle setTag:(-1)];
		// [MeineMatrix removeRowAt:r andFree:YES];
		// AnzahlMatrixFelder--;
	}
	return YES;
}

- entfernenKlick:sender
{
	NXSize	cellSize;
  NXRect	matrixRect, scrollRect;
	int			meinTag = 0, i = 0;
	id			zelle;
	
	[MeineMatrix sendAction:@selector(entfernen:)
		to:self forAllCells:NO];

	while (i < AnzahlMatrixFelder)
	{
		zelle = [MeineMatrix cellAt:i:0];
		meinTag = [zelle tag];
		if (meinTag == -1)
		{
			[MeineMatrix removeRowAt:i andFree:YES];
			AnzahlMatrixFelder--;
		}
		else
		{
			i++;
		}
	}

	[MeinScrollView getFrame:&scrollRect];
	[ScrollView getContentSize:&(matrixRect.size)
		forFrameSize:&(scrollRect.size)
	horizScroller:NO
	vertScroller:YES
	borderType:NX_BEZEL];

	[MeineMatrix getCellSize:&cellSize];
	cellSize.width = NX_WIDTH(&matrixRect);
	[MeineMatrix setCellSize:&cellSize];
	[MeineMatrix sizeToCells];
	[MeineMatrix setAutosizeCells:YES];
	[MeineMatrix nummernAendern];
	[MeinScrollView update];

	return self;
}

- (BOOL) prgSpeichern:sender //TODO
{
	return NO;
}

- (BOOL) prgLaden:sender //TODO
{
	return NO;
}

- (const char *) naechstesModule:(int) i
{
	const char	*mod;
	
	if ((i <= AnzahlMatrixFelder) && (i > 0))
		mod = [[MeineMatrix cellAt:i-1 :0] stringValue];
	else
		mod = NULL;
	return mod;
}

@end