
/* Generated by Interface Builder */

#import "Prefs.h"

static NXDefaultsVector ModPlayerDefaults =
{
	{"Klangspektrum", "JA"},
	{"Tiefpassfilter", "NEIN"},
	{"Endlosabspielen", "NEIN"},
	{"Programm-Modus", "NEIN"},
	{"Geschwindigkeit", "50"},
	{"Stereo-Effekt", "66"},
	{"Standardpfad", "/LocalLibrary/Tracks"},
	{"FFT-Speed", "100"},
	{NULL}
};

@implementation Prefs

- init:sender
{
	meinErzeuger = sender;
	
	if(!meinNIB)
		meinNIB = [NXApp loadNibLanguageFile:"Prefs.nib" owner:self withNames:NO];

	NXRegisterDefaults("ModPlayer", ModPlayerDefaults);
	
	[self setzePrefs];
	return self;
}

- setzeStdPfad:sender
{
	id dirPanel = [OpenPanel new];
	char *s;

	[[[dirPanel contentView]
		findViewWithTag:NX_OPTITLEFIELD]
		setStringValue:[stringTab valueForStringKey:"Verzeichnis"]];
		
	if ([dirPanel dirPanelRunModal:[StdPfad stringValue]] &&
		(s = (char *)[dirPanel directory]))
	{
		[StdPfad setStringValue:s];
	}

	return self;
}
	
- setzePrefs
{
	if((strcmp(NXGetDefaultValue("ModPlayer", "Klangspektrum"), "JA")) == 0)
		[Klangspektrum setIntValue:1];
	else
		[Klangspektrum setIntValue:0];

	if((strcmp(NXGetDefaultValue("ModPlayer", "Tiefpassfilter"), "JA")) == 0)
		[Tiefpass setIntValue:1];
	else
		[Tiefpass setIntValue:0];

	if((strcmp(NXGetDefaultValue("ModPlayer", "Endlosabspielen"), "JA")) == 0)
		[Endlos setIntValue:1];
	else
		[Endlos setIntValue:0];

	if((strcmp(NXGetDefaultValue("ModPlayer", "Programm-Modus"), "JA")) == 0)
		[ProgrammMode setIntValue:1];
	else
		[ProgrammMode setIntValue:0];

	[Stereo_F setStringValue:NXGetDefaultValue("ModPlayer", "Stereo-Effekt")];
	[Stereo_R setStringValue:NXGetDefaultValue("ModPlayer", "Stereo-Effekt")];
	[Geschwindigkeit_F
		setStringValue:NXGetDefaultValue("ModPlayer", "Geschwindigkeit")];
	[Geschwindigkeit_R
		setStringValue:NXGetDefaultValue("ModPlayer", "Geschwindigkeit")];
	[StdPfad setStringValue:NXGetDefaultValue("ModPlayer", "Standardpfad")];

	[FFTSpeed_R setStringValue:NXGetDefaultValue("ModPlayer", "FFT-Speed")];
	[FFTSpeed_F setStringValue:NXGetDefaultValue("ModPlayer", "FFT-Speed")];

	return self;
}

- setzeStdPrefs:sender
{
	[Klangspektrum setIntValue:1];
	[Tiefpass setIntValue:0];
	[Endlos setIntValue:0];
	[ProgrammMode setIntValue:0];
	[Stereo_F setIntValue:66];
	[Stereo_R setIntValue:66];
	[Geschwindigkeit_F setIntValue:50];
	[Geschwindigkeit_R setIntValue:50];
	[StdPfad setStringValue:"/LocalLibrary/Tracks"];
	[FFTSpeed_R setIntValue:100];
	[FFTSpeed_F setIntValue:100];
	return self;
}

- uebernehmePrefs:sender
{
	[meinErzeuger stellePrefsEin:NO];
 	[self sicherePrefs:self];
	return self;
}

- sicherePrefs:sender
{
	NXWriteDefault("ModPlayer", "Klangspektrum",
		([Klangspektrum intValue] == 1) ? "JA" : "NEIN");
	NXWriteDefault("ModPlayer", "Tiefpassfilter",
		([Tiefpass intValue] == 1) ? "JA" : "NEIN");
	NXWriteDefault("ModPlayer", "Endlosabspielen",
		([Endlos intValue] == 1) ? "JA" : "NEIN");
	NXWriteDefault("ModPlayer", "Programm-Modus",
		([ProgrammMode intValue] == 1) ? "JA" : "NEIN");
	
	NXWriteDefault("ModPlayer", "Stereo-Effekt", [Stereo_F stringValue]);
	NXWriteDefault("ModPlayer", "Geschwindigkeit",
		[Geschwindigkeit_F stringValue]);
	NXWriteDefault("ModPlayer", "Standardpfad", [StdPfad stringValue]);
	NXWriteDefault("ModPlayer", "FFT-Speed", [FFTSpeed_F stringValue]);

	NXUpdateDefaults();

	[meinPanel orderOut:self];
	return self;
}

- zeigePrefsFenster:sender
{
	[self setzePrefs];
	[meinPanel makeKeyAndOrderFront:self];
	return self;
}

- (int)endlosAbspielen
{
	return [Endlos intValue];
}

- (int)tiefpassFilter
{
	return [Tiefpass intValue];
}

- (int)klangSpektrum
{
	return [Klangspektrum intValue];
}

- (int)programmModus
{
	return [ProgrammMode intValue];
}

- (int)geschwindigkeit
{
	return [Geschwindigkeit_F intValue];
}

- (int)stereoEffekt
{
	return [Stereo_F intValue];
}

- (const char *)stdPfad
{
	return [StdPfad stringValue];
}

- (int)fftSpeed
{
	return [FFTSpeed_F intValue];
}

// Delegate fuer die Text-Felder
- (BOOL)textWillEnd:sender
{
	int i;

	switch ([[[sender delegate] selectedCell] tag])
	{
		case 0:
			i = [Geschwindigkeit_F intValue];
	
			if((i >= 30) && (i <= 80))
				return NO;
			else
				return YES;
			break;
		case 1:
			i = [Stereo_F intValue];
			if((i >= 0) && (i <= 100))
				return NO;
			else
				return YES;
			break;
		case 2:
			i = [FFTSpeed_F intValue];
			if ((i >= 40) && (i <= 120))
				return NO;
			else
				return YES;
			break;
	}
	return NO;
}

- textDidEnd:sender endChar:(unsigned short)c
{
	[Geschwindigkeit_R setIntValue:[Geschwindigkeit_F intValue]];
 	[Stereo_R setIntValue:[Stereo_F intValue]];
	[FFTSpeed_R setIntValue:[FFTSpeed_F intValue]];
	return self;
}

@end
