#import <appkit/Application.h>
#import <objc/hashtable.h>

#define	DEFAULT_LANGUAGE		"English"
#define	LANGUAGE_DIRECTORY_SUFFIX	"lproj"

@interface Application (Language)

- (NXAtom)applicationDirectory;
/*
 * Returns the directory name in which the application is running.  This is
 * useful for forming filenames within a file package.
 */

- (NXAtom)applicationFile:(const char *)fileName;
- (NXAtom)applicationFile:(const char *)fileName type:(const char *)fileExt;
/*
 * Given a filename (or a filename and a file extension), return the full
 * pathname of that file within the application's file package.
 */

- (NXAtom)findLanguageFile:(const char *)fileName type:(const char *)fileExt;
/*
 * This method looks in subdirectories of the running app for a file named:
 *	<root>/<language>.<suffix>/<filename>.<fileExt>
 * where <root> is the directory of the running app, <language> is one of the
 * languages specified by [NXApp systemLanguages], and <suffix> is named by
 * LANGUAGE_DIRECTORY_SUFFIX.
 *
 * This method will look for the file in a subdirectory of the running app,
 * trying each subdirectory named by [NXApp systemLanguages] in turn.  If the
 * desired file isn't found, the method searches for a directory named by 
 * DEFAULT_LANGUAGE.  Finally, if no file has been found, the method returns
 * a null pointer.
 */

- loadNibLanguageFile:(const char *)fileName owner:anOwner;
- loadNibLanguageFile:(const char *)fileName owner:anOwner
	withNames:(BOOL)aFlag;
/*
 * These two methods are similar to Application's methods loadNibFile:owner: 
 * and loadNibFile:owner:withNames, except that fileName is passed through
 * the findLanguageFile: method (above).
 */

@end
