
/* Generated by Interface Builder */

#import "FFTView.h"
#import "dpsclient/wraps.h"

@implementation FFTView

- neueWerte:(float *)werte
{
	int i;
	
	for(i=0;i<POINTS;i++)
		aktWerte[i] = werte[i];

	[self display];
	DPSFlush();
  return self;
}

- initFrame:(const NXRect *)frameRect
{
	int i;
	float xstart, xstep;

	[super initFrame:frameRect];
	[self setClipping:NO];
	[self allocateGState];

	xstep = frameRect->size.width / POINTS;
	xstart = frameRect->origin.x + xstep / 8.0;
	
	for (i = 0 ; i < POINTS; i++)
	{
		aktWerte[i] = 0.0;
		myRects[i].origin.x = xstart + i * xstep;
		myRects[i].origin.y = frameRect->origin.y;
		myRects[i].size.width = xstep * 3.0/4.0;
	}
	
	return self;
}

- drawSelf: (NXRect *) rects : (int) count
{
	int i;
	float xstart, xstep;
		
  PSsetgray (NX_LTGRAY);
  NXRectFill (&bounds);

	PSsetgray (NX_BLACK);

	xstep = bounds.size.width / POINTS;
	xstart = bounds.origin.x + xstep / 8.0;
	
	for(i = 0; i < POINTS; i++)
	{	
		myRects[i].origin.x = xstart + i * xstep;
		myRects[i].origin.y = bounds.origin.y;
		myRects[i].size.width = xstep * 3.0/4.0;
		myRects[i].size.height = 
			(log10 (aktWerte[i]))*.8 * bounds.size.height;
			
		// Test mit Minimum ein Pixel
		if (myRects[i].size.height < 1.0)
			myRects[i].size.height = 1.0;
		if (myRects[i].size.height >= bounds.size.height)
			myRects[i].size.height = bounds.size.height - 2.0;
	}
	
	NXRectFillList(myRects, POINTS);
	
	return self;
}
@end
