// CustomCell.m
// By Jayson Adams, NeXT Developer Support Team
// You may freely copy, distribute and reuse the code in this example.
// NeXT disclaims any warranty of any kind, expressed or implied, as to its
// fitness for any particular use.

// nderungen fr ModPlayer von Matthias Zepf, 1992

#import <dpsclient/psops.h>
#import <appkit/graphics.h>
#import <appkit/Font.h>
#import <appkit/NXImage.h>
#import <appkit/Text.h>

#import "CustomCell.h"

#define FIRST_COLUMN_START 7.0
#define SECOND_COLUMN_END 37.0
#define THIRD_COLUMN_START 45.0


@implementation CustomCell

/* every CustomCell needs this stuff */
static id 	attachmentImage = 0;
static NXSize	imageSize;

/* instance methods */

- init
{
    [super init];
    
  /* get the "attachment" image */
    if (!attachmentImage) {
	attachmentImage = [NXImage findImageNamed:"Attachment"];
	[attachmentImage getSize:&imageSize];
    }

    return self;
}
    
- setTag:(int)anInt
{
  /* we have to implement the tag methods ourselves */
    tag = anInt;
    
  /* we need to display its ASCII representation, so compute it now */
    sprintf(tagString, "%d", tag);

    return self;
}

- (int)tag
{
    return tag;
}

- setFont:fontObj
{
    [super setFont:fontObj];

  /*
   * save this info so we don't have to look it up every time we draw
   * Note:  support for a TextCell is a font object
   */
    
    NXTextFontInfo(support, &ascender, &descender, &lineHeight);
    
    return self;
}    

- drawInside:(const NXRect *)cellFrame inView:controlView
{
    float	stringWidth;
    NXPoint	imageOrigin;
    NXRect	rectArray[2];
    
  /* set the font according to our drawing status */
    if (NXDrawingStatus != NX_DRAWING) {
	stringWidth = [[support set] getWidthOf:tagString];
    } else {
	stringWidth = [[[support screenFont] set] getWidthOf:tagString];
    }
    
  /* erase the cell */
    PSsetgray((cFlags1.state || cFlags1.highlighted) ? NX_WHITE : NX_LTGRAY);
    NXRectFill(cellFrame);

  /* draw the "attachment" image */
    imageOrigin.x = FIRST_COLUMN_START;
    imageOrigin.y = NX_Y(cellFrame) + NX_HEIGHT(cellFrame) -
    		    (NX_HEIGHT(cellFrame) - imageSize.height) / 2.0;

  /*
   * the attachment image has a certain amount of transparency;  when we plusd
   * it on a ltgray background, it'll look "normal," while plusd'ing it on a
   * white background makes it look "highlighted"; this shows that you don't
   * need two images, one for each state;  note that this doesn't work when we
   * print since postscript has no concept of transparency
   */
    [attachmentImage composite:NX_PLUSD toPoint:&imageOrigin];
      
  /* draw the text */
    PSsetgray(NX_BLACK);
    PSmoveto(NX_X(cellFrame) + THIRD_COLUMN_START,
    	     NX_Y(cellFrame) + lineHeight - descender);
    PSshow(contents);
    
  /* all drawing from now on will be in dark gray */
    PSsetgray(NX_DKGRAY);
    
  /* draw the tag */
    PSmoveto(NX_X(cellFrame) + SECOND_COLUMN_END - stringWidth,
	     NX_Y(cellFrame) + lineHeight - descender);
    PSshow(tagString);
    
  /* draw the two dark gray lines above and below the cell */
    if (cFlags1.state || cFlags1.highlighted) {
      /*
       * draw 1-pixel tall rectangles instead of lines (this is faster than
       * PSmoveto(); PSlineto()).
       */
	NXSetRect(&(rectArray[0]), NX_X(cellFrame), NX_Y(cellFrame),
		NX_WIDTH(cellFrame), 1.0);
	NXSetRect(&(rectArray[1]), NX_X(cellFrame), NX_MAXY(cellFrame) - 1.0,
		NX_WIDTH(cellFrame), 1.0);

      /* using NXRectFillList is faster than separate calls to NXRectFill */
	NXRectFillList(rectArray, 2);
    }

    return self;
}

@end