// Copyright (94) by melonSoft Ralf Suckow Berlin, All Rights Reserved

// PRODUCER TYPES 
// Use these names to register server production objects with the
// name server. They are looked up by MLProducer on the localhost.
// The %s is the extension of document files handled by the server.

#define SCORE_PRODUCER_NAME     "MLScore-Production-Server-%s"
#define ORCHESTRA_PRODUCER_NAME "MLOrchestra-Production-Server-%s"
#define VOICE_PRODUCER_NAME     "MLVoice-Production-Server-%s"

// MESSAGES
// The following message is sent back when finished production.

@protocol MLProductionClient
- (oneway void)server:sender   // production object (currently not used)
           didRequest:(in int)number   // same as in the related request
              success:(in int)flag;       // 1 on success and 0 on error
@end

// The following messages are sent by MLProducer to the registered
// production objects in the servers. All filenames are full pathnames.

@protocol MLScoreProduction
- (oneway void) score:(const char *)documentFile         // a score file
             makeFile:(const char *)outputFile       // the raw notelist
            forClient:(id <MLProductionClient>)sender // reply to sender
              request:(in int)number;          // reply with this number
@end

@protocol MLOrchestraProduction
- (oneway void)
            orchestra:(const char *)documentFile    // an orchestra file
             makeFile:(const char *)outputFile  // the modified notelist
                 from:(const char *)inputFile        // the raw notelist
            forClient:(id <MLProductionClient>)sender
              request:(in int)number;
@end

@protocol MLVoiceProduction
- (oneway void) voice:(const char *)documentFile         // a voice file
             makeFile:(const char *)outputFile            // a .snd file
                 from:(const char *)parameters   // a list of parameters
            forClient:(id <MLProductionClient>)sender
              request:(in int)number;
@end

