// Copyright (94) by melonSoft Ralf Suckow Berlin, All Rights Reserved

/*
    M L P a r a m e t e r s
    -----------------------
    
    Parameter values are strings. 
    They can be mathematical values or literals (in parenthesis).
    They also can be converted to/from doubles or integers.
    
    History:
    
    28-Oct-92   created 
    29-Dec-92   divided into MLParameters and MLNote
*/

#import <appkit/appkit.h>

@interface MLParameters: Storage <NXTransport>
{
}

+ initialize;
+ template;
+ newFromStream:(NXStream *)stream syntaxOK:(BOOL *)flag;

- init;
- initFromStream:(NXStream *)stream syntaxOK:(BOOL *)flag;
- copy;
- free;
- empty;

- (int)startParameterIteration;
- (BOOL)next:(int *)state parName:(NXAtom *)name 
                          value:(const char **)value
                          literal:(BOOL *)flag;

- (BOOL)getParName:(NXAtom *)name
        value:(const char **)value 
        literal:(BOOL *)flag
        at:(int)index;

- getValue:(const char **)value
  literal:(BOOL *)flag
  forParName:(NXAtom)name;

- setPar:(NXAtom)name to:(const char *)val;
- setPar:(NXAtom)name toDouble:(double)val;
- setPar:(NXAtom)name toInt:(int)val;

- (const char *)valueFor:(NXAtom)name;
- (double)doubleValueFor:(NXAtom)name;
- (int)intValueFor:(NXAtom)name;
- (BOOL)isLiteral:(NXAtom)name;
- (BOOL)contains:(NXAtom)name;

- addPar:(NXAtom)name value:(const char *)val literal:(BOOL)flag;
- addPar:(NXAtom)name doubleValue:(double)val literal:(BOOL)flag;
- addPar:(NXAtom)name intValue:(int)val literal:(BOOL)flag;
- addPar:(NXAtom)name literal:(const char *)val;
- addPar:(NXAtom)name mathValue:(const char *)val;
- addPar:(NXAtom)name mathDoubleValue:(double)val;

- addParametersFrom:otherParameters;
- (NXAtom)atomForPar:(const char *)name 
  value:(const char *)value literal:(BOOL)flag;
- takePar:(NXAtom)name from:parameters;
- removeElementAt:(int)index;
- removePar:(NXAtom)name;
- (BOOL)isEqual:aParameterList;

// the stream representation is
// { <parameter> = ["]<value>["] ; ... }

- readFromStream:(NXStream *)stream syntaxOK:(BOOL *)flag;
- writeToStream:(NXStream *)stream;

// the math. stream does not contain brackets
// <parameter> = <value> ; ...

- writeMathToStream:(NXStream *)stream;
- readFromMathString:(const char *)string syntaxOK:(BOOL *)flag;
- (char *)getMathString;

@end
