/* Contoller.h
 * The Controller is provides all of the User Interface as well as the
 * computational "guts" of the TimeWarp application.
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Robert Poor
 * Created: Sep/92
 */

#import <objc/Object.h>
#import "DACPlayer.h"
#import <sound/sound.h>
#import <dpsclient/dpsclient.h>	/* for DPSTimedEntry */

#define SPEED_RANGE	4.0
/* 
 * speed will change from 1/SPEED_RANGE to SPEED_RANGE as the slider
 * is changed from 0 to 1.
 */

#define UPDATE_RATE	0.66667
/*
 * UPDATE_RATE determies how often we update the status display
 */

/***
 *** FIXPOINT DEFINITIONS
 *** We use fixpoint math in the inner loops.  A fixpoint number has
 *** the binary point right in the middle, so a fixpoint 1.0 is represented
 *** by 0x00010000, and .25 represented by 0x00004000.
 ***/

typedef	long	fixpoint_t;
#define LOG2_FIXPOINT_UNITY	(16)	
#define FIXPOINT_UNITY		(1<<LOG2_FIXPOINT_UNITY)

@interface Controller:Object
{
  /* principal UI components */
  id	window;		/* the main control panel */
  id	speedSlider;	/* slider to control speed */
  id	speedField;	/* text field to control speed */
  id	repeatButton;	/* repeat the sound when it stops */
  id	statusField;	/* text field for displaying general messages */
  id	queuedField;	/* text field to describe how much has been queued */
  id	playedField;	/* text field to describe how much has been played */
  id	completionView;	/* a CompletionView indicator */
  id	completionField;	/* a textField for the completion view */
  
  /* internal objects */
  DPSTimedEntry	updateTE;	/* timed entry for updating status display */
  DACPlayer	*dacPlayer;	/* an object to play the sound */
  char	*filename;		/* name of the sound file to be processed */
  SNDSoundStruct *srcSound;	/* sound structure associated with filename */
  short	*src, *srcBase, *srcEnd;	/* cached pointers to sound data */
  float rate;			/* rate at which we play the sound */
  fixpoint_t	fixRate;	/* fixpoint representation of current rate */
  fixpoint_t	residue;	/* current fractional offset from src */
  BOOL	stoppedManually;	/* set to true when the stop button pushed */
}

- init;
- free;
- appDidInit:sender;

- openSoundFile:sender;
/* open a sound file for playback */

- closeSoundFile:sender;
/* close existing sound file */

- play:sender;
/* start playing a sound */

- stop:sender;
/* stop playing current sound */

- pause:sender;
/* pause (or prepare) the current sound */

- setSpeedLinear:sender;
/*
 * Set the playback speed linearly.  The speed will be set to the value as
 * returned by [sender floatValue].
 */

- setSpeedLogarithmic:sender;
/*
 * set the speed logarithmically.  The speed will be set to 1/SPEED_RANGE to
 * SPEED_RANGE as [sender floatValue] ranges from 0 to 1.
 */

/**
 ** Delegate methods for the DACPlayer
 **/

- willPlay :player;
- didPlay :player;
- playData :player :(char *)data :(int)nbytes;
- didChangeState :player from:(Pla_state_t)old to:(Pla_state_t)new;

@end