;;; To be used with NeXT Scorefile Package Version 3
(require :scorefile)
(use-package 'scorefile)
(score drum ((tempo 240)))

(header "

envelope ampFn2  =  [(0,0)(.001,1,.05)(.5,0,1.4)(.501,0)|(.520,0)(.521,0,.5)];
envelope indFn3  =  [(0,1)(.001,1,.05)(.2,0,.5)];
envelope indFn4  =  [(0,1)(.001,1,.05)(.02,0,1)];

/* Conga wave table */
waveTable cn = [{1,1}{3,.5}{5,.05}];

/* Cowbell functions */
envelope cbAmpFn  =  [(0,0)(.001,1,.2)(.3,0,.8)|(.31,0,.5)];
envelope cbIndFn  =  [(0,0)(.001,1,.2)(.3,0,.3)];
waveTable cb1 = [{1,1}{3,.1}];
waveTable cb2 = [{1,1}{4,1}{7,1}{11,.5}{13,.2}{17,.1}];
")

(defvar endtime 30)

(part conga   ; Create a new part, guitar
      ("Fm2cnvi" (synthPatchCount 1) (rvibAmp 0) (svibAmp 0))
      (list 0 endtime)       ; Time offset (none, in this case) 
      :noteOn ; Type of notes to use.
      ;; Now come parameter definitions. 
      (amp .060)
      (ampEnv "ampFn2")
      (waveLen 128)
      (waveform "cn")
      (cRatio 2.0)
      (m1Ratio 3.41)
      (m1IndEnv "indFn3")
      (m2Ratio 7.515)
      (m2IndEnv "indFn4")
      (noiseAmp1 .7)
      (noiseAmpEnv "indFn4")
      (velocitySensitivity 1.0)
      (bearing 40)
      (rvibAmp 0)
      (svibAmp 0)
      (phase 0 :always)

      (velocity '(cycle '(30 60 60)))
      (dur (rhythm q))
      (timeTag (accumulate-durs))
      (freq '(cycle '((+ (random 20) 74) :r)))
      (m1Ind1 1.276)
      (m2Ind1 5)
      (phase 0)
      (m1Phase 45)
      (m2Phase 45)
)


(part conga2   ; Create a new part, guitar
      ("Fm2cnvi" (synthPatchCount 1) (rvibAmp 0) (svibAmp 0))
      (list 0 endtime)       ; Time offset (none, in this case) 
      :noteOn ; Type of notes to use.
      ;; Now come parameter definitions. 
      (amp .060)
      (ampEnv "ampFn2")
      (waveLen 128)
      (waveform "cn")
      (cRatio 2.0)
      (m1Ratio 3.41)
      (m1IndEnv "indFn3")
      (m2Ratio 7.515)
      (m2IndEnv "indFn4")
      (noiseAmp1 .7)
      (noiseAmpEnv "indFn4")
      (velocitySensitivity 1.0)
      (bearing 40)
      (rvibAmp 0)
      (svibAmp 0)
      (phase 0 :always)

      (velocity '(+ 30 (random 30)))
      (dur '(cycle (rhythms q e)))
      (timeTag (accumulate-durs))
      (freq '(cycle '((+ (random 20) 100) :r)))
      (m1Ind1 '(+ (random .3) 1.276))
      (m2Ind1 5)
      (phase 0)
      (m1Phase 45)
      (m2Phase 45)
)

(part cowbell   ; Create a new part, guitar
      ("DBFm1vi" (synthPatchCount 1) (rvibAmp 0))
      (list 0 endtime)       ; Time offset (none, in this case) 
      :noteOn ; Type of notes to use.
      ;; Now come parameter definitions. 
      (velocitySensitivity 1.0)
      (amp .060)
      (ampEnv "cbAmpFn")
      (waveLen 128)
      (waveform "cb1")
      (cRatio 1.0)
      (m1Ratio 1.618)
      (m1IndEnv "cbIndFn")
      (m1Waveform "cb2")
      (bearing -34)
      (rvibAmp 0)
      (dur '(cycle (rhythms 4 4 8 4 4 4 8)))
      (timeTag (accumulate-durs))
      (velocity 60)
      (freq 587)
      (m1Ind1 2.0)
)

(write-score drum)  ; Write it out
(play) ; play it

