: run this script through /bin/sh

if [ -z "$1" ]; then
    echo "usage: bootmhn.sh MH-library-area" 1>&2
    exit 1
fi
LIB="$1"
MHN="$LIB/mhn_defaults"

if [ -s $MHN ]; then
    echo "%s: already exists." 1>&2
    exit 1
fi
TMP=/tmp/mhn$$
trap "rm -f $TMP" 0 1 2 3 13 15

echo "mhn-store-text: %m%P.txt" >> $TMP
echo "mhn-store-application/PostScript: %m%P.ps" >> $TMP

PGM="`./bootmhn.findit xwud $LIB`"
if [ ! -z "$PGM" ]; then
    XWUD="$PGM" X11DIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
else
    XWUD= X11DIR=
fi

PGM="`./bootmhn.findit pbmtoxwd $LIB`"
if [ ! -z "$PGM" ]; then
    PBM="$PGM" PBMDIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
else
    PBM= PBMDIR=
fi

PGM="`./bootmhn.findit xv $LIB`"
if [ ! -z "$PGM" ]; then
    echo "\
mhn-show-image: %p$PGM -geometry =-0+0 %f" >> $TMP
elif [ ! -z $"PBM" -a ! -z "$XWUD" ]; then
    echo "\
mhn-show-image/gif: %p${PBMDIR}giftoppm | ${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0
mhn-show-image/x-pbm: %p${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0
mhn-show-image/x-pgm: %p${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0
mhn-show-image/x-ppm: %p${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0
mhn-show-image/x-xwd: %p$XWUD -geometry =-0+0" >> $TMP

    PGM="`./bootmhn.findit djpeg $LIB`"
    if [ ! -z "$PGM" ]; then
	echo "\
mhn-show-image/jpeg: %p$PGM -Pg | ${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    fi
fi

if [ -c "/dev/audio" ]; then
    PGM="`./bootmhn.findit raw2audio $LIB`"
    if [ ! -z "$PGM" ]; then
	AUDIODIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
	echo "\
mhn-store-audio/basic: | ${AUDIODIR}raw2audio -e ulaw -s 8000 -c 1 > %m%P.au
mhn-store-audio/x-next: %m%P.au" >> $TMP
	echo "\
mhn-compose-audio/basic: ${AUDIODIR}record | ${AUDIODIR}raw2audio -F
mhn-show-audio/basic: %p${AUDIODIR}raw2audio 2>/dev/null | play" >> $TMP

	PGM="`./bootmhn.findit adpcm_enc $LIB`"
	if [ ! -z "$PGM" ]; then
	    DIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
	    echo "\
mhn-compose-audio/x-next: ${AUDIODIR}record | ${DIR}adpcm_enc
mhn-show-audio/x-next: %p${DIR}adpcm_dec | ${AUDIODIR}play" >> $TMP
	else
	    echo "\
mhn-compose-audio/x-next: ${AUDIODIR}record
mhn-show-audio/x-next: %p${AUDIODIR}play" >> $TMP
	fi
    else
	echo "\
mhn-compose-audio/basic: cat < /dev/audio
mhn-show-audio/basic: %pcat > /dev/audio" >> $TMP
    fi
fi

echo "mhn-show-application/PostScript: %plpr -Pps" >> $TMP    

PGM="`./bootmhn.findit richtext $LIB`"
if [ ! -z "$PGM" ]; then
	echo "\
mhn-show-text/richtext: %p$PGM -p %F" >> $TMP
else
    PGM="`./bootmhn.findit rt2raw $LIB`"
    if [ ! -z "$PGM" ]; then
	echo "\
mhn-show-text/richtext: %p$PGM < %f | fmt -78 | more" >> $TMP
    fi
fi

PGM="`./bootmhn.findit xterm $LIB`"
if [ ! -z "$PGM" ]; then
	echo "\
mhn-charset-iso-8859-1: xterm -fn '-*-*-medium-r-normal-*-*-120-*-*-*-*-iso8859-*' -e %s" >> $TMP
fi

sort < $TMP > $MHN
chmod 644 $MHN

exit 0

: not until we get a "safe" postscript environment...

PGM="`./bootmhn.findit pageview $LIB`"
if [ "$DISPLAY" = "unix:0.0" -a ! -z "$PGM" ]; then
    echo "mhn-show-application/PostScript: %p$PGM -" >> $TMP    
else
    PGM="`./bootmhn.findit gs $LIB`"
    if [ ! -z "$PGM" ]; then
	echo "mhn-show-application/PostScript: %p$PGM -- %F" >> $TMP
    fi
fi
