
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

main(argc, argv)
int argc;
char *argv[];
{	int k;

	f_header(argc-1);

	for (k = 1; --argc; k++) dumptrack(argv[k]);
}

FILE *fopen();

dumptrack(name)
char *name;
{	FILE *f;
	struct stat statbuf;
	int c;

	if (stat(name, &statbuf)) {
		perror(name);
		return;
    	}

	t_header(statbuf.st_size + 4);
	/**t_header(statbuf.st_size + 17);**/

	if ( (f = fopen(name, "r")) == NULL ) {
		fprintf(stderr, "no file %s\n", name);
		exit(1);
	}

	while ( (c = getc(f)) != EOF ) {
		putchar(c);
	}
	t_trailer();

	fclose(f);
}


WriteInt(value)
int value;
{
	putchar((value >> 24)&0xff);
	putchar((value >> 16)&0xff);
	putchar((value >> 8)&0xff);
	putchar((value)&0xff);
}

WriteShort(value)
int value;
{
	putchar((value >> 8)&0xff);
	putchar((value)&0xff);
}

f_header(numtracks)
int numtracks;
{
/*
		4D 54 68 64 	MThd
		00 00 00 06	chunk length
		00 00 	format 0
		00 01	one track
		00 60 	96 per quarter-note
*/
	printf("MThd");
	WriteInt(6);
	WriteShort((numtracks > 1)? 1 : 0);
	WriteShort(numtracks);
	WriteShort(96);
	/*putchar(-25);*/	/* 25 frames per sec */
	/*putchar(4);*/	/* 4 ticks per frame */
}

t_header(tracksize)
int tracksize;
{
/*
		4D 54 72 6B	MTrk
		00 00 00 3B	chunk length (59)
*/
	printf("MTrk");
	WriteInt(tracksize);

/* put these in?
	00	FF 58 04 04 02 18 08 	time signature
	00	FF 51 03 07 A1 20	tempo
*/
/**
	putchar(0xff);
	putchar(0x58);
	putchar(0x04);
	putchar(0x04);
	putchar(0x02);
	putchar(0x18);
	putchar(0x08);
	putchar(0xff);
	putchar(0x51);
	putchar(0x03);
	putchar(0x07);
	putchar(0xa1);
	putchar(0x20);
**/
}

t_trailer()
{
	putchar(0);
	putchar(0xff);
	putchar(0x2f);
	putchar(0);
}
