#define name_length 255

#define num_voices 16
#define minpitch -12
#define maxpitch 115
#define NO_PITCH (maxpitch+1)
#define minprogram 1
#define maxprogram 128

struct note_struct {
    long ndur;		/* duration */
    char npitch;	/* pitch (middle C = 48) */
    char nloud;		/* loudness (MIDI velocity) */
    char nprogram;	/* adagio Z parameter (MIDI program) */
    };

struct ctrl_struct {
    unsigned char value;
    };

typedef struct event_struct {
    struct event_struct *next;
    long ntime;		/* start time */
    int nline;		/* line number from source code */
    char nvoice;	/* adagio voice (MIDI Channel)
			 *  if this is a control change, high order 4 bits
			 *  contain the control number, otherwise high order
			 *  4 bits are 0 (see is_note macro below)
			 */
    union {
	struct note_struct note;
	struct ctrl_struct ctrl;
	} u;
    } *event_type;

#define nctrl 7
#define ctrlsize (sizeof(struct event_struct) - \
		  sizeof(struct note_struct) + sizeof(struct ctrl_struct))
#define ctrl_voice(c, v) (((c) << 4) + (v))
#define vc_ctrl(v) ((v) >> 4)
#define vc_voice(v) ((v) & 0x0F)
#define is_note(n) (((n)->nvoice & 0xF0) == 0)
