/*   Adagio compiler -- scan command line, call phase1, phase2 */

/*****************************************************************************
*	    Change Log
*  Date	    | Change
*-----------+-----------------------------------------------------------------
* 12-Mar-86 | Created
* 28-May-86 | Added calls to cmdline.c for command line parsing
*****************************************************************************/

#include "cext.h"
#include <stdio.h>
#include "adagio.h"
#include "phase1.h"
#include "phase2.h"
#include "userio.h"
#include "cmdline.h"

boolean verbose = false;
char score_na[name_length];  /* this will be available to phase1 and 2 */

/****************************************************************************
* Variables set by command line switches
****************************************************************************/

/****************************************************************************
* Data for command line parsing
****************************************************************************/
#define nswitches 8
private char *switches[nswitches] = 
    { "-help", "-print",
      "-init", "-i", "-trace", "-t", "-midi", "-m" };

#define noptions 1
private char *options[noptions] = { "-tune" };

/****************************************************************************
*	Routines local to this module
****************************************************************************/
private void cmdline_help();

/****************************************************************************
*				 cmdline_help
* Effect: 
*	Prints out command line help
****************************************************************************/

private void cmdline_help()
{
    fprintf(stderr,"am [options] filename [options]\n");
    fprintf(stderr,"	   -help	     this message\n");
    fprintf(stderr,"	   -init (-i)        initialize channels\n");
    fprintf(stderr,"	   -print	     print note data\n");
    fprintf(stderr,"	   -tune file	     use tuning from file\n");
    fprintf(stderr,"	   -trace (-t)       trace music\n");
    fprintf(stderr,"	   -midi (-m)        midi file on stdout\n");
}

/****************************************************************************
*				     main
* Inputs:
*	int argc: Count of arguments
*	char * argv[]: Vector of argument pointers
* Effect: 
*	Runs adagio
****************************************************************************/

void main(argc,argv)
   int argc;
   char * argv[];
{
    FILE *fp = NULL;
    char *s;	/* temp pointer to input file name */

    cl_init(switches, nswitches, options, noptions, argv, argc);

    score_na[0] = 0;

    if (cl_switch("-help")) {
	cmdline_help(); 
	return;
    }

    /* get input file: */
	if ((s = cl_arg(1)) != NULL) strcpy(score_na, s);
	fp = fileopen(score_na, "gio", "r", "Name of Adagio score file");

    phase2(phase1(fp));
}
