#include <midi.h>
#include <mpuvar.h>

dx7PutParameter(midi, channel, group, par, data)
	int midi;	/* file descriptor of midi device */
	char channel;	/* midi channel (0 -> ch 1) */
	char group;	/* parameter group # (0 or 2) */
	short par;	/* dx7 parameter number */
	char data;	/* parameter data (0-127) */
/*
 * Send parameter change, return '-1' on error, '0' otherwise.
 * This is to tweak an individual dx7 voice parameter
 * (e.g., if you wanted to change the level of one operator).
 * Use 'group=0' for common dx7 voice parameter;
 * 'group=2' for dx7 function parameter.
 * 'par' is  a parameter number and 'data' is the new parameter value.
 * Example: 'dx7PutParameter(midi,0,0,134,1)'
 * sets the current algorithm (par=134) to '1'.
 * See MIDI-spec (section 1.2.4) and libdx7.h
 * for more information about parameters.
 */
{
	static u_char s[] =
		{MPU_SEND_SYSTEM_MESSAGE,
		 SX_CMD,
		 ID_DX7,
		 0, 0, 0, 0, /* parameter bytes go here */
		 SX_EOB};
	u_char *p = s+3;
	/* Note: the dx7 documentation is wrong here.
	 * to send a parameter change, there are 9 bits of parameter
	 * (not 16, like the documentation says)
	 * spread over 2 words, and 7 bits of data:
	 
	  0sssnnnn      sub status (s=0) & channel number (n=0 -> ch1)
	  0gggggpp      parameter group number (g=0 -> common dx7 voice parameter,
                        g=2 -> dx7 function parameter)
	  0ppppppp      parameter number
	  0ddddddd      data

	 */
	p[0] = DX7_SXSS_PC << 4 | (channel & M_CHAN_MASK);
	p[1] = ((group<<2) | ((par>>7)&0x03)) & M_VAL_MASK;  /* top 2 bits of 'par' */
	p[2] = par & M_VAL_MASK;	/* bottom 7 bits of 'par' */
	p[3] = data & M_VAL_MASK;	/* parameter data */
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,sizeof s);
	MpuSetTrack(midi,0);
}
