#include <midi.h>
#include <mpuvar.h>

dx7PutControl(midi, channel, control, value)
/*
** Set the dx7 'control' to 'value'.
** For instance, to turn down the dx7 volume, do
** .Cs
** dx7PutControl(midi, channel, DX7_CTL_VOLUME, 40)
** .Ce
** At the moment, this is hacked to transmit pitch bend to the dx7, too:
** .Cs
** dx7PutControl(midi, channel, CH_P_BEND, 100)
** .Ce
** does this.
** See also MIDI-spec section 2.1.
*/
{
        static unsigned char s[5];
	unsigned char c = control==CH_P_BEND? CH_P_BEND : CH_CTL;
        s[0] = MPU_WANT_TO_SEND_DATA;
        s[1] = c | channel;
        s[2] = control & M_VAL_MASK;
        s[3] = value & M_VAL_MASK;
        s[4] = value & M_VAL_MASK;
        MpuSetTrack(midi,MPU_TR_COM);
        write(midi,s,c==CH_P_BEND? 5 : 4);
        MpuSetTrack(midi,0);
}
/*
main(ac,av) char *av[]; {
	int midi = open(MidiDevice,2);
	MpuSend(midi,MPU_RESET,0);
	dx7PutControl(midi,0,DX7_CTL_VOLUME,atoi(av[1]));
}
*/
