#include <stdio.h>
#include <midi.h>
static Period = MPU_CLOCK_PERIOD;

MidiStretch(in, out, factor)
	FILE *in, *out;
	float factor;
/*
** Copy MIDI data from 'in' to 'out', multiplying the times by 'factor'
** to stretch or compress the events.
** Example: 'MidiStretch(in,out,.5)' halves the rate (playing the data
** twice as fast).
*/
{
	long when = 0;
	MpuCmd m;

	while (GetMpuCmd(in, &m)) {
	    when += factor * ((m.time_tag == RT_TCIP)? Period : m.time_tag);
	    if (m.time_tag != RT_TCIP)
		MpuPut(out, &m, when);
	}
	MpuPut(out, 0, when);
}
