#include <midi.h>
#include <mpuvar.h>
#include <dx7voice.h>

#define u_char	unsigned char
#define u_short	unsigned short

dx7PutVoice(midi, chan, v, n)
	int midi;	/* file descriptor of midi device */
	u_char chan;	/* midi channel (0 -> ch[1]) */
	Dx7Voice *v;	/* voice being stuffed */
	int n;		/* which voice (0-31) position on the dx7 */
/*
 * Load voice 'v' into dx7 internal voice 'n'
 * return 0 on error, 1 if okay.
 * If 'n = -1', load voice in current position,
 * otherwise load voice into program 'n' (0-based).
 * `NB:` the dx7 must have cs{SYS INFO AVAIL} with cs{MEM PROTECT} off.
 * See tag 'Mvput' for an example.
 */
{
/*
  11110000      status byte
  0iiiiiii      identification number (i=67 -> YAMAHA;
  0sssnnnn      sub status (s=0) & channel number (n=0 -> ch1)
  0fffffff      format number (f=0 -> 1 voice)
  0bbbbbbb      byte count MS byte
  0bbbbbbb      byte count LS byte
  0ddddddd      data 1st byte
    ...
  0ddddddd      data 155th byte
  0eeeeeee      check sum
*/
	static u_char header[] =
		{MPU_SEND_SYSTEM_MESSAGE,
		 SX_CMD,
		 ID_DX7,
		 0, 0, 0, 0, 0, /* some voice bytes go here */
		 SX_EOB};
	short sv = SizeofDx7Voice+1;
	u_char *p = header+3;

	*p++ = DX7_SXSS_BD << 4 | (chan & M_CHAN_MASK);
	*p++ = 0;	/* 1 voice */
	*p++ = (sv >> 7) & M_VAL_MASK;
	*p++ = sv & M_VAL_MASK;
	*p++ = checksum(v, SizeofDx7Voice);
	sv--;

	if (n>-1) dx7SetVoice(midi,chan,n);
	MpuSetTrack(midi,MPU_TR_COM);
	if (write(midi,header,7) != 7) return 0;/* write the header */
	if (write(midi,v,sv) != sv) return 0;	/* write voice */
	if (write(midi,header+7,2) != 2) return 0;
	MpuSetTrack(midi,0);
	return 1;
}
/*
main(){
	Dx7Voice *dx7ReadVoice(), 
		 *v = dx7ReadVoice("/usr/midi/lib/dx7/voices/floot");
	int midi = open("/dev/mpu0",2);
	MpuSend(midi,MPU_RESET,0);
	printf("%d\n", dx7PutVoice(midi,0,v,-1));
}
*/
