/*
**	VELPAT		psl 4/89
** Copy midi data, applying a velocity pattern to the key-on events.
*/
#include	<stdio.h>
#include	<midi.h>

#define	MAXPLEN	1024
#define	MAXCNUM	128

int	Pat[MAXPLEN];
int	*Pp	= Pat;
int	Plen	= 0;
int	Rptlen	= 0;	/* if nonzero, pattern has fixed timing */
int	Ptime	= 0;	/* Rptlen / Plen */

#define	ABS	1
#define	REL	2
#define	SCALE	8
#define	UNITY	(1 << SCALE)

typedef	struct	symstr	{
	char	c;		/* associated character */
	int	t;		/* operation type */
	int	v;		/* operation value */
} SYM;

SYM	S[MAXCNUM]	= {
	{ 255, 0, 0, },		/* unused */
	{ '.', REL, UNITY, },
	{ '-', REL, UNITY >> 1, },
	{ '+', REL, UNITY << 1, },
	{ '0', ABS, 0, },
	{ '1', ABS, 3, },
	{ '2', ABS, 18, },
	{ '3', ABS, 34, },
	{ '4', ABS, 49, },
	{ '5', ABS, 65, },
	{ '6', ABS, 80, },
	{ '7', ABS, 96, },
	{ '8', ABS, 111, },
	{ '9', ABS, 127, },
	{ '\0', },
};

main(argc, argv)
char	*argv[];
{
	int i = 1, n = 0;
	FILE *f;

	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'p': litpat(argv[++i]); break;
		case 'f': filpat(argv[++i]); break;
		case 'r':
		    Rptlen = atoi(&argv[i][2]);
		    if (!Rptlen)
			Rptlen = 2 * MPU_CLOCK_PERIOD;
		    break;
		default: goto syntax;
		}
	    } else
		n++;
	}
	Plen = Pp - Pat;
	if (!Plen) {
syntax:
	    fprintf(stderr,
	     "Usage: %s [-f FILE] [-p PATTERN] [-r[#]] [files or stdin]\n",
	     argv[0]);
	    fprintf(stderr, "-f FILE\ttakes pattern definition from FILE.\n");
	    fprintf(stderr, "-p PAT\tuses argument as pattern definition.\n");
	    fprintf(stderr, "-r fixes pattern in time & repeats every bar.\n");
	    fprintf(stderr,
	     "-r# fixes pattern in time & repeats every # clocks.\n");
	    fprintf(stderr,
	     "default is to use 1 pattern element per key-on.\n");
	    exit(2);
	}
	Ptime = Rptlen / Plen;
	if (n == 0)
	    velpat(stdin, stdout);
	else {
	    for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-')
		    continue;
		if (f = sopen(argv[i], "r")) {
		    velpat(f, stdout);
		    sclose(f);
		} else
		    perror(argv[i]);
	    }
	}
	exit(0);
}

litpat(string)
char	*string;
{
	register char *cp;
	register int i;
	extern double atof();


	if (string[1] == '=') {
	    i = lookup(string[0]);
	    S[i].c = string[0];
	    S[i].t = ABS;
	    S[i].v = atoi(&string[2]);
	} else if (string[1] == '*') {
	    i = lookup(string[0]);
	    S[i].c = string[0];
	    S[i].t = REL;
	    S[i].v = UNITY * atof(&string[2]);
	} else {
	    for (cp = string; *cp; cp++) {
		if (*cp == ' ' || *cp == '\t')
		    continue;
		i = lookup(*cp);
		if (S[i].c == '\0') {
		    fprintf(stderr, "Undefined pattern char: %c\n", *cp);
		    i = 0;
		}
		*Pp++ = i;
	    }
	}
}

filpat(file)
char	*file;
{
	char buf[512];
	int i;
	FILE *fp;

	if (!(fp = fopen(file, "r"))) {
	    perror(file);
	    exit(1);
	}
	while (fgets(buf, sizeof buf, fp))
	    litpat(buf);
	fclose(fp);
}

lookup(ch)
char	ch;
{
	register int i;

	for (i = 1; S[i].c && S[i].c != ch; i++);
	return(i);
}

velpat(in, out)
FILE	*in, *out;
{
	register int v, *pp;
	long now;
	SYM *sp;
	MCMD *mp;

	pp = Pat;
	for (now = 0L; mp = getmcmd(in, now); now = mp->when) {
	    if ((mp->cmd[0] & M_CMD_MASK) == CH_KEY_ON) {
		if ((v = mp->cmd[2]) > 0) {
		    if (Rptlen)			/* fixed time */
			sp = &S[Pat[(mp->when % Rptlen) / Ptime]];
		    else {			/* per key-on */
			sp = &S[*pp++];
			if (sp->c == '\0') {		/* wrap around */
			    pp = Pat;
			    sp = &S[*pp++];
			}
		    }
		    if (sp->t == ABS)
			mp->cmd[2] = sp->v;
		    else if (sp->t == REL) {
			v = sp->v * v;
			mp->cmd[2] = (v < 1)? 1 : ((v > 255)? 255 : v);
			mp->cmd[2] = sp->v;
		    }
		}
	    }
	    putmcmd(out, mp);
	}
}
