/*
**	TRANSPOSE -- Transpose Midi note on/off events
**	psl 2/87
*/
#include	<stdio.h>
#include	<midi.h>

#define	MAXCHANS	MIDI_MAX_CHANS

int	Tr[MAXCHANS];			/* per channel transpositions */

main(argc, argv)
char	*argv[];
{
	char *cp;
	int i, dt, stat, chan;
	long now;
	MCMD *mp;

	if (argc < 2) {
syntax:
	    fprintf(stderr, "Usage: %s [#] [C=#] ... <file\n", argv[0]);
	    fprintf(stderr, "C is a channel number [1:16].\n");
	    fprintf(stderr, "# is the transposition in half steps.\n");
	    fprintf(stderr, "#o is the transposition in octaves.\n");
	    fprintf(stderr, "12, +12, 1o, & +1o all mean up one octave.\n");
	    fprintf(stderr, "-12 & -1o both mean down one octave.\n");
	    fprintf(stderr, "A single number transposes all channels.\n");
	    fprintf(stderr, "Evalustion is left-to-right;\n");
	    fprintf(stderr, "thus '+12 2=0' makes sense, but not '2=0 +12'\n");
	    exit(2);
	}
	for (i = 1; i < argc; i++) {
	    for (cp = argv[i]; *cp && *cp != '='; cp++);
	    if (*cp++ == '=') {
		chan = atoi(argv[i]) - 1;
		if (chan < 0 || chan >= MAXCHANS)
		    goto syntax;
		Tr[chan] = steps(cp);
	    } else if (i == 1) {
		dt = steps(argv[i]);
		for (chan = MAXCHANS; --chan >= 0; Tr[chan] = dt);
	    } else
		goto syntax;
	}
	for (now = 0L; mp = getmcmd(stdin, now); now = putmcmd(stdout, mp)) {
	    stat = (mp->cmd[0] & M_CMD_MASK);
	    if (stat == CH_KEY_ON || stat == CH_KEY_OFF) {
		chan = (mp->cmd[0] & M_CHAN_MASK);
		if (Tr[chan]) {
		    i = mp->cmd[1] + Tr[chan];
		    mp->cmd[1] = i < 1? 1 : (i > 127? 127 : i);
		}
	    }
	}
}

steps(cp)
register char *cp;
{
	int trans;

	if (*cp == '+')
	    cp++;
	trans = atoi(cp);
	while (*cp == '-' || ('0' <= *cp && *cp <= '9'))
	    cp++;
	if (*cp == 'o')
	    trans *= 12;
	return(trans);
}
