/*
**	PSEQ -- Create "Pointed Sequences"
**
**	1) all 16th notes
**	2) pentatonic
**	3) 1/f-ish motion
**	4) no repeated notes
*/

#include <stdio.h>
#include <midi.h>

#define	WHOLE		(MPU_CLOCK_PERIOD << 1)
#define	SIXTEENTH	(MPU_CLOCK_PERIOD >> 3)

int	Scale[]	= { 0, 2, 4, 7, 9, };
int	Scalen	= sizeof Scale / sizeof Scale[0];

main(argc, argv)
char	*argv[];
{
	u_char mbuf[4], *seq;
	int ss, i, t, len, ckey, seed;
	MCMD m;

	len = 32;
	ckey = key2ss(60);		/* pitch center */
	ss = key2ss(48);		/* first note */
	seed = 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'c':		/* pitch center */
		    ckey = key2ss(name2key(&argv[i][2]));
		    break;
		case 'i':		/* initial note */
		    ss = key2ss(name2key(&argv[i][2]));
		    break;
		case 'l':		/* length (16ths) */
		    len = atoi(&argv[i][2]);
		    break;
		case 's':		/* random number seed */
		    seed = atoi(&argv[i][2]);
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr,
		 "Usage: %s [-cKEY] [-iKEY] [-l#] [-s#]\n", argv[0]);
		fprintf(stderr, " -cKEY sets pitch center (C3, 0x3c, 60)\n");
		fprintf(stderr, " -iKEY sets initial note (C3, 0x3c, 60)\n");
		fprintf(stderr, " -l# sets the length in sixteenth notes\n");
		fprintf(stderr, " -s# sets the random number seed\n");
		exit(2);
	    }
	}
	if (seed)
	    srand(seed);
	else
	    srand((int) time(0));
	m.len = 3;
	m.cmd = mbuf;
	m.cmd[0] = CH_KEY_ON;
	m.when = 0;
	for (t = 0; t < len; t++) {
	    m.cmd[1] = (ss / Scalen) * 12 + Scale[ss % Scalen];
	    m.cmd[2] = 64;
	    putmcmd(stdout, &m);
	    m.when += SIXTEENTH;
	    m.cmd[2] = 0;
	    putmcmd(stdout, &m);
	    for (i = ss; ss == i; )
		ss = (ss + ss + ckey) / 3 + rand() % 5 - rand() % 5;
	}

}

key2ss(key)
{
	register int i;

	for (i = Scalen; --i > 0 && Scale[i] > (key % 12); );
	return(Scalen * (key / 12) + i);
}
