/*	CONDUCT -- Control MPU speed "out-of-band", psl 1/89
*/

#include	<suntool/sunview.h>
#include	<suntool/panel.h>
#include	<midi.h>
#include	<stdio.h>

#define	FONTPATH	"/usr/lib/fonts/fixedwidthfonts/screen.r.14"
#define	PGV(I)		panel_get_value(I)
#define	PSV(I,V)	panel_set_value(I,V)

#define	OFF	0		/* MPU not open */
#define	ON	1		/* MPU open */

Frame	Dframe;			/* whole display's frame */
Pixfont	*Fontp;			/* the font we use (almost everywhere) */
Panel	Controls;		/* control panel */

Panel_item	Tmpo;		/* slider; tempo */

main(argc, argv)
char	*argv[];
{
/****/setbuf(stderr, 0);
	while (--argc > 0) {
	    if (argv[argc][0] == '-') {
		switch (argv[argc][1]) {
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s\n", argv[0]);
		exit(2);
	    }
	}
/****
	if (fork() > 0)
	    exit(0);
****/
	miscinits();
	window_main_loop(Dframe);
	exit(0);
}

miscinits()	/* one-time SunView inits */
{
	Rect tmp;
	void winevent();

	tmp.r_left = 800;
	tmp.r_top = 64;
	tmp.r_width = 336;
	tmp.r_height = 25;
	Dframe = window_create(NULL, FRAME,
	    FRAME_LABEL,		"CONDUCTOR",
	    WIN_FONT,			Fontp,
	    WIN_EVENT_PROC,		winevent,
	    FRAME_OPEN_RECT,		&tmp,
	    0);
	gencntl();
}

gencntl()	/* generate control panel; called also to re-generate */
{
	void cntlproc();

	if (Controls) {
	    window_destroy(Controls);
	    Controls = 0;
	}
	Controls = window_create(Dframe, PANEL,
	    WIN_X,		0,
	    WIN_Y,		0,
	    WIN_FONT,		Fontp,
	    PANEL_SHOW_MENU,	FALSE,
	    PANEL_LABEL_BOLD,	TRUE,
	    PANEL_ITEM_X_GAP,	25,
	    0);

	Tmpo = panel_create_item(Controls, PANEL_SLIDER,
	    PANEL_LABEL_STRING,		"TEMPO",
	    PANEL_MIN_VALUE,		10,
	    PANEL_VALUE,		100,
	    PANEL_MAX_VALUE,		240,
	    PANEL_SLIDER_WIDTH,		230,
	    PANEL_SHOW_RANGE,		FALSE,
	    PANEL_NOTIFY_PROC,		cntlproc,
	    0);
	window_fit_width(Controls);
	window_fit_height(Controls);
	window_fit(Dframe);
}

void
cntlproc(item, value, event)
Panel_item item;
Event	*event;
{
	char buf[128];

	if (item == Tmpo) {
	    buf[0] = MPU_TEMPO;
	    buf[1] = (u_char) PGV(Tmpo);
	    if (write(1, buf, 2) != 2)
		perror("MPU write failed");
	} else
	    fprintf(stderr, "item = 0x%x?\n", item);
}

void
winevent(window, event, arg)
Window	window;
Event	*event;
caddr_t	arg;
{
	if (event_id(event) == WIN_RESIZE)
	    gencntl();
	window_default_event_proc(window, event, arg);
}
