/* Main event loop for Think C implementation of CSound.
 * Bill Gardner, August, 1990.	*/

#include	<stdio.h>
#include	"tc_misc.h"

EventRecord	ev;				/* current event */
Boolean RUNNING;			/* TRUE if still doing event loop */

main()
{
	Init();
	MainEventLoop();
}

DoKeyDown()
{
	if (ev.modifiers & cmdKey)
		DoMenuClick(MenuKey((char)ev.message));
}

DoMouseDown(auto_open)
int auto_open;		/* TRUE if need to fake a File menu "Open..." event */
{
int where;
WindowPtr wp;
extern long fileOpenSelect();
	where = auto_open ? inMenuBar : FindWindow(ev.where,&wp);
	switch(where) {
	default:
	case inDesk:
		break;
	case inMenuBar:
		DoMenuClick(auto_open ? fileOpenSelect() : MenuSelect(ev.where));
		break;
	case inSysWindow:
		SystemClick(&ev,wp);
		break;
	case inContent:
		break;
	case inDrag:
		break;
	case inGrow:
		break;
	case inGoAway:
		break;
	}
}

MainEventLoop()
{
int auto_open = TRUE;	/* TRUE: fake File menu Open ScorOrch evt on launch */
						/* FALSE: only do "Open" if document double-clicked */
	while(RUNNING) {
		SystemTask();
		if (auto_open) ev.what = mouseDown;
		else GetNextEvent(everyEvent,&ev);
		switch(ev.what) {
		default:
		case nullEvent:
			break;
		case mouseDown:
			DoMouseDown(auto_open);
			auto_open = FALSE;
			break;
		case mouseUp:
			break;
		case keyDown:
		case autoKey:
			DoKeyDown();
			break;
		case updateEvt:
			break;
		case activateEvt:
			break;
		}
	}
}

Init()
{
	InitGraf(&thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(0L);
	cursInit();
    setupMenuBar();
    initConfig();
	FlushEvents(everyEvent,0);
	RUNNING = TRUE;
}

bufclr(p,n)
char *p;
int n;
{
	while (n--) *p++ = 0;
}
