///////////////////////////////////////////////////////////////////////////////
// $Id: Sound.hxx,v 1.1 1995/01/08 06:48:32 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Sound.hxx - Sound class
//
//
// Bradford W. Mott
// Copyright (C) 1995
// January 4,1995
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Sound.hxx,v $
// Revision 1.1  1995/01/08  06:48:32  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef SOUND_HXX
#define SOUND_HXX

#include "SampleCollection.hxx"

enum SoundState { Enabled, Disabled };


class Sound {
  private:
    SampleCollection* mySampleCollection; 
    SoundState myState;

  public:
    // Constructor
    Sound::Sound(SampleCollection* sampleCollection);

    // Destructor 
    virtual ~Sound();

    // Play the named sample
    virtual void playSample(char* sampleName);    

    // Answer my state
    SoundState state() const { return(myState); }
};
#endif

