/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _CALLBACKS
#define _CALLBACKS

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "types.h"
#include "riskgame.h"

void CBK_XIncomingMessage(XtPointer pClientData, int *iSource, XtInputId *id);
void CBK_IncomingMessage(Int iMessType, void *pvMessage);
void CBK_RefreshMap(Widget w, XtPointer pData, XtPointer call_data);
void CBK_RefreshDice(Widget w, XtPointer pData, XtPointer call_data);
void CBK_MapClick(Widget w, XtPointer pData, XEvent *pEvent);
void CBK_Register(Widget w, XtPointer pData, XtPointer call_data);
void CBK_StartGame(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Quit(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ShowCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_CancelCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Attack(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Action(Widget w, XtPointer pData, XtPointer call_data);
void CBK_MsgDest(Widget w, XtPointer pData, XtPointer call_data);
void CBK_CancelAttack(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Repeat(Widget w, XtPointer pData, XtPointer call_data);
void CBK_Help(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ExchangeCards(Widget w, XtPointer pData, XtPointer call_data);
void CBK_EndTurn(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ArmiesShell(Widget w, XtPointer pData, XtPointer call_data);
void CBK_HelpOk(Widget w, XtPointer pData, XtPointer call_data);
void CBK_HelpSelectTopic(Widget w, XtPointer pData, XtPointer call_data);
void CBK_ObjectMessage(Int iMessType, void *pvMess);

extern Int      iActionState, iCurrentPlayer;
extern Int      iLastAttackSrc, iLastAttackDst, iState;
extern Int      iAttackSrc, iAttackDst;
extern Int      iMoveSrc, iMoveDst;
extern Boolean  fGameStarted, fGetsCard, fCanExchange, fForceExchange;
extern Boolean  fRegistrationEnded;
extern Int      iIncomingCard, iReply;
extern Char     strScratch[256];

/* Relating to the message destination listbox */
extern String  pstrMsgDstString[];
extern Int     piMsgDstPlayerID[];
extern Int     iIndexMD;

#endif

