#ifndef _TRANS_H
#define _TRANS_H

#include <stdio.h>
#include "hash.h"
#include "defs.h"
#include "savefile.h"

// limit number of players to 16. Divide up 2^32 into 16 blocks and
// allocate id's based on player id, everyone hashes into the table
// to find the id's

class City;
class Unit;

class LongKey
{
public:
  LongKey(ulong l) { n = l; }
  ulong HashValue() { return n; }
  int operator==(LongKey &k) { return n == k.n; }

  ulong n;
};

class TransTable
{
public:
  TransTable(ulong playerId) : trans(1001) { nextId = (playerId<<28)+1L; }
  TransTable() : trans(1001) { nextId = ReadULong(); }
  ~TransTable() {}

  void *Translate(ulong id) { return (void *)trans.Find(LongKey(id)); }

  ulong New() { return nextId++; }
  void SetPtr(ulong id, void *ptr) { trans.Insert((char*)ptr, LongKey(id)); }

  City *TransCity(ulong id) { return (City *)Translate(id); }
  Unit *TransUnit(ulong id) { return (Unit *)Translate(id); }

  void Save() { WriteULong(nextId); }

private:
  HashTable<char,LongKey> trans;
  ulong nextId;
};

#endif
