/* MAIN.H - XTron main file header

   Rhett D. Jacobs   <rhett@jaemol.cbr.fidonet.org>

   Version 1.0

   Last Modified: 1/1/95
 */

#ifndef MAIN_H
#define MAIN_H

#include <string.h>
#include <sys/types.h>
#include <sys/time.h>

#ifndef WINTYPE_H
#include "wintype.h"
#endif
#ifndef XTRON_H
#include "xtron.h"
#endif

/* interface windows */
#include "bitmaps/computer.h"
#include "bitmaps/human.h"
#include "bitmaps/humanr.h"
#include "bitmaps/comprr.h"
#include "bitmaps/again.h"
#include "bitmaps/pause.h"
#include "bitmaps/quit.h"

/* player pieces and background */
#include "bitmaps/p1.h"
#include "bitmaps/p2.h"
#include "bitmaps/p3.h"
#include "bitmaps/back.h"

#define TOTAL_WIDTH 384
#define TOTAL_HEIGHT 512
#define LOOK_AHEAD 25


Display	*display;
int screen;
Window main_window;
GC gc;
unsigned long foreground;
unsigned long background;

int p_state = 1;

/* game windows */
Window game_port, plr1_win, plr2_win, pause_win, again_win, quit_win;
Window plr1_human, plr1_computer, plr2_human, plr2_computer;

/* set pixmap for interface */
Pixmap human_pic, computer_pic, again_pic, pause_pic, quit_pic;
Pixmap human_rev, computer_rev;

/* player pieces bitmaps */
Pixmap p_im[3], board_im;

extern struct Player p[2];
extern struct Board b;

void ButtonEvent(XButtonEvent *pEvent);
void KeyEvent(XKeyEvent *pEvent);
void ExposeEvent(XExposeEvent *pEvent);
Window set_window(int x, int y, int width, int height);
void mapwindows(void);
Pixmap set_icon(char *bits, unsigned int width, unsigned int height);
int check_valid(int p_num, int x_inc, int y_inc);
void think(int p_num);
int game_update(void);
void delay(int len);
void restart_game(void);
void open_windows(int argc, char **argv);
void assign_bitmaps(void);

#endif
