/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "screen.h"
#include <vga.h>

pixel* Screen::gmem;
int Screen::scrwidth=320;
int Screen::scrheight=200;

Screen::Screen(void)
{
        if(gmem==0)
                gmem=vga_getgraphmem();
}

void
Screen::copy(const Screen& s)
{
	gmem=s.gmem;
	scrwidth=s.scrwidth;
	scrheight=s.scrheight;
}

Screen::Screen(const Screen& s)
{
	copy(s);
}

Screen&
Screen::operator=( const Screen &s)
{
	copy(s);
	return *this;
}
