#ifndef PLAYER_H
#define PLAYER_H
#include "sprite.h"
#include "action.h"

#define NUMLIVES 3

class
Player : public Sprite
{
private:
	int score, lives;
	bool alive;
	action dir;
public:
	Player();
        Player(const Player& p);
        Player& operator=(const Player& p);

	bool getAlive(void) const {return alive;}
	int getScore(void) const {return score;}
	int getLives(void) const {return lives;}
	action getDir(void) const {return dir;}

	void setDir(action d){dir=d;}
	void setAlive(bool a) {alive=a;}

	void setScore(int s){score=s;}
	void setLives(int l){lives=l;}
	void addScore(int s){score+=s;}
	void subLife(void){ lives--; if (lives<1) alive=FALSE;}
	void addLife(void){lives++;}
};

#endif
