/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

/* C++ code for block copy wrapper */

#include "block.h"
#include "asmblock.h"

extern "C" {
#include "screendefs.h"
#include "btypes.h"
}

byte* Block :: gmem;

void 
Block :: Cut ( uint32 x1, uint32 y1, uint32 xw, uint32 yw)
{
	width=xw;
	height=yw;

	/* if memory in use then free it */
	if( blockmem!=0 ) delete blockmem; 

	/* reserve block memory */
	blockmem=new byte [xw*xw];

	/* call assembly routine */
	cutblock( gmem+x1+(y1*SCREENWIDTH), blockmem, width, height); 
}

void
Block :: Recut( uint32 x1, uint32 y1)
{
	/* call assembly routine */
	cutblock( gmem+x1+(y1*SCREENWIDTH), blockmem, width, height); 
}

void
Block :: Paste( uint32 x1, uint32 y1)
{
	/* Straight into the assembly bit */
	xorpasteblock( blockmem, gmem+x1+(y1*SCREENWIDTH), width, height );
}
