
#include "GObject.h"
#include <vga.h>
#include <vgagl.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#define 	W	32
#define 	H	25

#define		GMODE	G640x480x256
char data[W][H];

int main(int argc, char *argv[])
{
	FILE *in  = fopen(argv[1],"rb");
	FILE *out = fopen(argv[2],"wb");
	void	* object;
	void 	* buffer = malloc(W*H+6);

	if(argc < 2)
	{	printf("Usage: convert in out\n");
		return 1;
	}
	assert(in);	
	assert(out);
	assert(buffer);
	
	vga_setmode(GMODE); 
	gl_setcontextvga(GMODE);
	
	object = new(GObject, W, H, 1);
	while(! feof(in))
	{ 	fread(buffer,W*H+6,1,in);
		setdata(object,buffer+6);
		display(object, 0,0);
		save(object,out);
		getchar();
	}
	vga_setmode(TEXT);
	
	return 0;
}
