/* $Id: tfio.h,v 30000.22 1993/05/25 01:08:31 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef TFIO_H
#define TFIO_H

#ifdef HAVE_STDARG
# include <stdarg.h>
#else
# include <varargs.h>
#endif

#include "dstring.h"

extern int errno;

#define TF_NULL     0
#define TF_QUEUE    1
#define TF_FILE     2
#define TF_PIPE     3

typedef struct TFILE {
    int type;
    char *name;
    union {
        struct Queue *queue;
        FILE *fp;
    } u;
} TFILE;                       /* TF's analogue of stdio's FILE */

extern TFILE *tfout;           /* ... stdout */
extern TFILE *tferr;           /* ... stderr */

#define operror(str)  tfprintf(tferr, "%% %s: %s", str, STRERROR(errno))
#define oputs(str)    tfputs(str, tfout)
#define oputa(aline)  tfputa(aline, tfout)
#define tfputc(c, file) fputc((c), (file)->u.fp)
#define tfflush(file) fflush((file)->u.fp)           /* undefined for QUEUEs */

extern char   *FDECL(tfname,(char *name, char *macname));
extern String *FDECL(expand_filename,(Stringp str));
extern TFILE  *FDECL(tfopen,(char *name, char *mode));
extern int     FDECL(tfjump,(TFILE *file, long offset));
extern int     FDECL(tfclose,(TFILE *file));
extern void    FDECL(tfputs,(char *str, TFILE *file));
extern void    FDECL(tfputa,(Aline *aline, TFILE *file));
extern void    FDECL(vSprintf,(Stringp buf, char *fmt, va_list ap));
extern void    VDECL(Sprintf,(Stringp buf, char *fmt, ...));
extern void    VDECL(oprintf,(char *fmt, ...));
extern void    VDECL(tfprintf,(TFILE *file, char *fmt, ...));
extern char    NDECL(igetchar);
extern String *FDECL(fgetS,(Stringp str, FILE *stream));
extern String *FDECL(tfgetS,(Stringp str, TFILE *file));

#endif /* TFIO_H */
