/* unparse.c */

#include <string.h>
#include "config.h"
#include "db.h"
#include "externs.h"
#include "interface.h"

const char *real_unparse(player, loc, obey_myopic)
     dbref player;
     dbref loc;
     int obey_myopic;
{
    static char buf[BUFFER_LEN];

    Access(loc);
    switch (loc) {
      case NOTHING:
	return "*NOTHING*";
      case HOME:
	return "*HOME*";
      default:
	if ((Can_Examine(player, loc) || can_link_to(player, loc) ||
	     IS(loc, TYPE_ROOM, ROOM_JUMP_OK) || (Flags(loc) & CHOWN_OK) ||
	     IS(loc, TYPE_THING, THING_DEST_OK)) && 
	    (!Myopic(player) || !obey_myopic)) {
	    /* show everything */
	    sprintf(buf, "%s(#%d%s)", Name(loc), loc,
		    unparse_flags(loc, player));
	    return buf;
	} else {
	    /* show only the name */
	    return Name(loc);
	}
    }
}

static char boolexp_buf[BUFFER_LEN];
static char *buftop;

static void unparse_boolexp1(player, b, outer_type, flag)
    dbref player;
    struct boolexp *b;
    boolexp_type outer_type;
    int flag;    /*  0 is full unparse, 1 is numbers-only */
{
  char tbuf1[BUFFER_LEN];

  if (b == TRUE_BOOLEXP) {
    safe_str((char *)"*UNLOCKED*", boolexp_buf, &buftop);
    return;
  } else {
    switch (b->type) {
      case BOOLEXP_AND:
	if (outer_type == BOOLEXP_NOT) {
	  safe_chr('(', boolexp_buf, &buftop);
	}
	unparse_boolexp1(player, b->sub1, b->type, flag);
	safe_chr(AND_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub2, b->type, flag);
	if (outer_type == BOOLEXP_NOT) {
	  safe_chr(')', boolexp_buf, &buftop);
	}
	break;
      case BOOLEXP_OR:
	if (outer_type == BOOLEXP_NOT || outer_type == BOOLEXP_AND) {
	  safe_chr('(', boolexp_buf, &buftop);
	}
	unparse_boolexp1(player, b->sub1, b->type, flag);
	safe_chr(OR_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub2, b->type, flag);
	if (outer_type == BOOLEXP_NOT || outer_type == BOOLEXP_AND) {
	  safe_chr(')', boolexp_buf, &buftop);
	}
	break;
      case BOOLEXP_IND:
	safe_chr(AT_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub1, b->type, flag);
	break;
      case BOOLEXP_IS:
	safe_chr(IS_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub1, b->type, flag);
	break;
      case BOOLEXP_CARRY:
	safe_chr(IN_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub1, b->type, flag);
	break;
      case BOOLEXP_OWNER:
	safe_chr(OWNER_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub1, b->type, flag);
	break;
      case BOOLEXP_NOT:
	safe_chr(NOT_TOKEN, boolexp_buf, &buftop);
	unparse_boolexp1(player, b->sub1, b->type, flag);
	break;
      case BOOLEXP_CONST:
	if (flag) {
	  sprintf(tbuf1, "#%d", b->thing);
	  safe_str(tbuf1, boolexp_buf, &buftop);
	} else
	  safe_str(unparse_object(player, b->thing), boolexp_buf, &buftop);
	break;
      case BOOLEXP_ATR:
	sprintf(tbuf1, "%s:%s", b->atr_lock->name,
		uncompress(b->atr_lock->text));
	safe_str(tbuf1, boolexp_buf, &buftop);
	break;
      case BOOLEXP_EVAL:
	sprintf(tbuf1, "%s/%s", b->atr_lock->name,
		uncompress(b->atr_lock->text));
	safe_str(tbuf1, boolexp_buf, &buftop);
	break;
      default:
	safe_str((char *)"Bad boolexp type!", boolexp_buf, &buftop);
	fprintf(stderr, "ERROR: unparse_boolexp1 bad boolexp type on #%d\n",
		player);
	break;
      }
  }
}

const char *unparse_boolexp(player, b, flag)
    dbref player;
    struct boolexp *b;
    int flag;    /*  0 is full unparse, 1 is numbers-only */
{
  buftop = boolexp_buf;
  unparse_boolexp1(player, b, BOOLEXP_CONST, flag);	/* no outer type */
  *buftop++ = '\0';
  return boolexp_buf;
}
