/* $Id: com.c,v 1.2 1993/03/03 03:54:09 nils Exp $ */

#include "config.h"
#include "externs.h"

static int is_on_channel P((dbref,char *));
static int is_on_channel(player,chan)
     dbref player;
     char *chan;
{
  char *clist;
  char *clbegin;
  static char buf[1025];

  sprintf(buf,"%s ",atr_get(player,A_CHANNEL));
  clbegin=clist=buf;
  while(*clist) {
    if(strchr(clist,' '))
      *strchr(clist,' ') ='\0';
    if(!strcmp(clist,chan)) {
      return (clist-clbegin);
    }
    clist+=strlen(clist)+1;
  }
  return -1;
}

extern void com_send (channel, message)
     char *channel;
     char *message;
{
  struct descriptor_data *d;
  for (d = descriptor_list; d; d=d->next)
    if (d->connected && d->player>0 && is_on_channel(d->player, channel)>=0) {
      queue_string(d, message); 
      queue_string(d, "\n");
    }
}
static void com_who P((dbref, char *));
static void com_who (player, channel)
     dbref player;
     char *channel;
{
  struct descriptor_data *d;
  for (d = descriptor_list; d; d=d->next)
    if (d->connected && d->player>0 && is_on_channel(d->player, channel)>=0) {
      notify(player,tprintf("%s is on channel %s.",
			    unparse_object(player,d->player),channel));
    }
  notify(player,tprintf ("--- %s ---",channel));
}

void do_com(player, arg1, arg2)
     dbref player;
     char *arg1;
     char *arg2;
{
  if (!*arg1) {
    static char buf[1024];
    char *s;
    strcpy(buf,atr_get(player,A_CHANNEL));
    if ((s=strchr(buf,' ')))
      *s = '\0';
    arg1 = buf;
  }
  if (!*arg1) {
    notify(player,"no channel.");
    return;
  }
  if (strchr(arg1,' ')) {
    notify(player,"you're spacey.");
    return;
  }
  if (!string_compare(arg2,"who"))
    com_who(player,arg1);
  else {
    char buf[2048];
    if (Typeof(player) != TYPE_PLAYER && !power(player,POW_SPOOF)) {
      notify(player,"non-players can not send +com messsages.");
      return;
    }
    sprintf (buf, "[%s] %s%s %s",arg1,db[player].name,(*arg2 == ':')?"":":",
	     (*arg2 == ':')?(arg2+1):arg2);
    com_send(arg1, buf);
    if (is_on_channel(player,arg1)<0)
      notify(player,"your +com has been sent! yay!");
  }
}

void do_channel(player,arg1)
     dbref player;
     char *arg1;
{
  ptype k;
  char buf[1024];
  
  if(*arg1 == '\0') {
    if(*atr_get(player,A_CHANNEL))
      notify(player,tprintf("You are currently on the following channels: %s",
			    atr_get(player,A_CHANNEL)));
    else {
      notify(player,"You aren't currently on any channels. For a general chatting channel, turn to");
      notify(player,"channel 'public'");
    }
  } else if(*arg1 == '+') {
    arg1++;
    if(Typeof(player)!=TYPE_PLAYER) {
      notify(player,"as of yet, non-players cannot talk on channels.");
      return;
    }
    if (!db[player].pows) return;
    k= *db[player].pows;
    if(*arg1 == '*' &&
       !(k==CLASS_ADMIN ||
	 k==CLASS_DIR)) {
      notify(player,"Permission denied!");
      return;
    }
    if(*arg1 == '.' &&
       !(k==CLASS_DIR ||
	 k==CLASS_ADMIN ||
	 k==CLASS_BUILDER)) {
      notify(player,"Permission denied!");
      return;
    }
    if(*arg1 == '_' &&
       !(k==CLASS_DIR ||
	 k==CLASS_ADMIN ||
	 k==CLASS_BUILDER ||
	 k==CLASS_OFFICIAL ||
	 k==CLASS_JUNOFF)) {
      notify(player,"Permission denied!");
      return;
    }
    if (strchr(arg1,' ')) {
      notify(player,"Sorry, channel names can not have spaces in them.");
      return;
    }
    if (!*arg1) {
      notify(player,"what channel?");
      return;
    }
    if (is_on_channel(player,arg1)>=0) {
      notify(player,"You are already on that channel.");
      return;
    }
    if(!*atr_get(player,A_CHANNEL))
      atr_add(player,A_CHANNEL,arg1);
    else
      atr_add(player,A_CHANNEL,tprintf("%s %s",arg1,atr_get(player,A_CHANNEL)));
    sprintf(buf,"[%s] %s has joined this channel.",arg1 , db[player].name);
    com_send(arg1,buf);
    notify(player,tprintf("%s added to your channel list.",arg1));
  } else if(*arg1 == '-') {
    int i;
    char *end;
    char buf2[1024];

    arg1++;
    
    if (strchr(arg1,' ') || !*arg1) {
      notify(player,"sigh. such sillyness. try a less spacey channel name.");
      return;
    }
    i = is_on_channel(player, arg1);
    if (i<0) {
      notify(player,"you aren't on that channel.");
      return;
    }
    strcpy(buf,atr_get(player,A_CHANNEL));
    end = strchr(buf+i,' ');
    if (!end)
      end=strchr(buf+i,'\0');
    else
      end++;
    strcpy (buf2, atr_get(player,A_CHANNEL));
    strcpy(buf2+i, end);
    if ((end=strchr(buf2,'\0')) && *--end==' ') *end='\0';

    notify(player,tprintf("%s has been deleted from your channel list.",
			  arg1));
    sprintf(buf,"[%s] %s has left this channel.",arg1,db[player].name);
    com_send(arg1,buf);
    atr_add (player, A_CHANNEL, buf2);
  } else {
    notify(player,"Usage:");
    notify(player,"  +channel +<channel>    :adds a channel");
    notify(player,"  +channel -<channel>    :deletes a channel");
    notify(player,"  +channel               :lists your channels.");
    notify(player,"For a general chatting channel, try channel 'public'.");
  }
}
