/*
 * Domain handling stuff.
 */

private mixed *domains;

private string *get_member_list(string domain) {
    int i;

    for (i=0; i < sizeof(domains); i++)
	if (domains[i][0] == domain)
	    return domains[i];
    return 0;
}

private string *load_member_list(string domain) {
    string file;
    string content;

    file = "/d/" + domain + "/MEMBERS";
    content = read_file(file);
    if (content == 0)
	return 0;
    return explode(content, "\n");
}
    

int domain_member(string domain, string name) {
    int i;
    string *member_list;

    if (domains == 0)
	domains = ({});
    member_list = get_member_list(domain);
    if (member_list == 0) {
	member_list = load_member_list(domain);
	domains += ({ member_list });
    }
    if (member_list == 0)
	return 0;
    if (member_array(name, member_list) != -1)
	return 1;
    return 0;
}
