/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/


/**********************************************************************

io.c	: loads graphic data, level definitions and highscores
	  saves highscores

*****************************************************end of header*****/

#include "io.h"

#ifdef OS_DOS
#	include <alloc.h>
#endif 
#include <limits.h>	/* PATH_MAX */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "bdash.h"
#include "react.h"
#include "movers.h"
#include "scores.h"
#include "zfopen.h"

/*
** Level laden und in level_table ablegen 
*/
int load_level(unsigned level_no)
{
	int help;

	FILE *leveldatei;
	int y,x, diamant_count=0,  /* 4 diamonds, 4 doors, 4 keys */
		 door_count = 0,
		 key_count = 0;
	unsigned real_x_size, real_y_size;
	unsigned long pr;
	char dateiname[PATH_MAX];
	char inputbuffer[100], *cptr;

	debug_printf("entering load_level()\n");

	sprintf(dateiname,DATAPATH FILELEVEL,level_no);
	if(NULL ==(leveldatei = zfopen(dateiname,"rt")))
	{ 	perror("load_level");
		return -1; /* Fehler beim Dateioeffnen */
	}
	fscanf(leveldatei,"%u %u %lu ", &real_y_size, &real_x_size, &pr);
	fgets(level_name, LEVEL_NAME_MAXLEN, leveldatei);
	cptr = level_name;
	while(*cptr)
		if(*cptr == '\r' || *cptr == 13)	/* eat ^M and CR */
			*cptr = '\0';
		else
			cptr++;

	points_required += pr;
	level_x_size = real_x_size <  8 ?  8: real_x_size;
	level_y_size = real_y_size < 10 ? 10: real_y_size;

	/* Platz fuer Tabelle von Zeigern auf die Zeilen einrichten */
	if((level_table = calloc(level_y_size,sizeof(char *)))==NULL)
		fatal_error("load_level out of mem");

	for(y=0;y<level_y_size;y++) /* read level one line after another */
	{ 	/* get memory for line */
		if((level_table[y] = calloc(level_x_size+1,sizeof(unsigned char)))==NULL)
			fatal_error("load_level out of mem");
		fgets((char *)level_table[y],real_x_size+1,leveldatei);

		for(help=0, x=0;x<level_x_size;x++)
			if(level_table[y][x] == '\n')
				level_table[y][x] = '\0', help = 1;
		if(! help)
			fgets(inputbuffer,101,leveldatei);	/* read \n */

		for(x=0;x<level_x_size;x++) /* Umwandeln in Indices */
		{ 	switch(level_table[y][x])
			{ 	case ' ': 	level_table[y][x] = FELD_LEER;
						break;
				case '1': 	level_table[y][x] = FELD_SPIELER_1;
						player_x[0] = x; player_y[0] = y;
						break;
				case '2': 	level_table[y][x] = (globale_flags.twoplayer)?FELD_SPIELER_2:FELD_ERDE;
						player_x[1] = x; player_y[1] = y;
						break;
				case '.': 	level_table[y][x] = FELD_ERDE;
						break;
				case 'B': 	level_table[y][x] = FELD_BOMBE;
						break;
				case 'S': 	level_table[y][x] = FELD_STEIN;
						break;
				case 'M': 	level_table[y][x] = FELD_MAUER;
						break;
				case 'D': 	level_table[y][x] = (diamant_count+++FELD_DIAMANT_1);
						diamant_count%=4;
						break;
				case '(': 	level_table[y][x] = FELD_KAEFER_2;
						add_object(x,y,STRAIGHT_BEETLE,FELD_KAEFER_2,0);
						break;
				case '%': 	level_table[y][x] = FELD_KAEFER_1;
						add_object(x,y,STD_BEETLE,FELD_KAEFER_1,0);
						break;
				case '&': 	level_table[y][x] = FELD_KAEFER_3;
						add_object(x,y,RANDOM_BEETLE,FELD_KAEFER_3,0);
						break;
				case '$': 	level_table[y][x] = FELD_KAEFER_4;
						add_object(x,y,UPDOWN_BEETLE,FELD_KAEFER_4,0);
						break;
				case '-':	level_table[y][x] = FELD_KAEFER_5;
						add_object(x,y,LR_BEETLE,FELD_KAEFER_5,0);
						break;
				case 'C':	level_table[y][x] = FELD_CHEESE_1;
						add_object(x,y,CHEESE1,FELD_CHEESE_1,0);
						break;
				case 'K': 	level_table[y][x] = (key_count+++FELD_KEY_1);
						key_count%=4;
						break;
				case 'T':	level_table[y][x] = (door_count+++FELD_TOR_1);
						door_count%=4;
						break;
				case 'w':	level_table[y][x] = FELD_WATER;
						break;
				default: 	level_table[y][x] = FELD_LEER;
			}
		}
	}
	fclose(leveldatei);
	/* Achtung, bei 2 Spieler Modus bei Slave  Figuren vertauschen! */
	if(globale_flags.twoplayer && globale_flags.slavemode)
	{ 	level_table[player_y[0]][player_x[0]] = FELD_SPIELER_2;
		level_table[player_y[1]][player_x[1]] = FELD_SPIELER_1;
		help = player_x[0]; player_x[0] = player_x[1]; player_x[1] = help;
		help = player_y[0]; player_y[0] = player_y[1]; player_y[1] = help;
	}
	for(y=0;y<level_y_size;y++)
	{ 	for(x=0;x<level_x_size;x++)
		switch(level_table[y][x])
		{	case FELD_BOMBE: case FELD_BOMBE_2:
			case FELD_STEIN: case FELD_STEIN_2:
			case FELD_DIAMANT_1:case FELD_DIAMANT_2:
			case FELD_DIAMANT_3:case FELD_DIAMANT_4:
			bearbeite_feld(x,y);
		}
		react();
	}
	for(y = 0; y < 4; y ++)	/* Schluessel auf 0 setzen */
		keys[0][y] = keys[1][y] = (unsigned char)'\0';

	debug_printf("leaving load_level()\n");
	return 0;
#pragma warn -aus
}

void free_level(void)	/* free memory allocated */
{
	int y;

	for(y=0;y<level_y_size;y++) /* Level zeilenweise einlesen */
	{	free(level_table[y]);
		level_table[y] = NULL;
	}

	free(level_table);
}


int load_scores(void)	/* nomen est omen */
{
	FILE *input;

	if((input = fopen(HSCPATH FILESCORE,"rb")) == NULL)
		return -1;
	if(fread(highscore_table,sizeof(highscore_table),1,input)
		< 1)
		{
			fclose(input);
			return -2;
		}
	fclose(input);
	return 0;
}

int save_scores(void)
{
	FILE *output;

	if((output = fopen(HSCPATH FILESCORE,"wb")) == NULL)
		return -1;
	if(fwrite(highscore_table,sizeof(highscore_table),1,output)
		< 1)
		{	fclose(output);
			return -2;
		}
	fclose(output);
	return 0;
}


void fatal_error(char *err)
{	
	extern void cleanup(void);
	
	fprintf(stderr,"\a\a\aBoulder-Dash: fatal error occured: %s\n\rError code: %s\n\r",err,strerror(errno));
#ifdef DEBUG
	fprintf(stderr,"calling cleanup():\n");
	cleanup();
	fprintf(stderr,"debugging enabled: forcing core-dump:\n");
	abort();
#else
	exit(EXIT_FAILURE);
#endif
}
/*
 * debug.c: debugging routines for ooc
 *
 *	call to d_entry generates message like:
 *		--------> function(parms) in file "aha.c" at line 7
 *	call to d_leave generates message like:
 *	<------- function() in file "aha.c" at line 19
 *
 *	both routines write to stderr
 */
#ifdef DEBUG

int depth = 0;
#define 	MAX_RECURSION 	30
char *fcalls[MAX_RECURSION]; 	/* maximum recursion-depth monitored */

#define TABULATE	int i; for(i=0;i<depth;i++) fputc('\t', stderr);

void debug_entry(char * fcall, char *file, int line)
{
	TABULATE

	fprintf(stderr, "-------> %s  in file %s at line %d\n",
		fcall, file, line);
	if(depth < MAX_RECURSION)
		fcalls[depth] = fcall;
	depth++;
}

void debug_leave(char *file,  int line)
{
	char *fcall;
	TABULATE

	if(depth < MAX_RECURSION)
		fcall = fcalls[depth];
	else
		fcall = "unknown()";
	depth--;
	fprintf(stderr, "<------- in file %s at line %d\n",
		fcall, file, line);
}
#else
void debug_entry(char *fcall, char *file, int line)
{}
void debug_leave(char *file, int line)
{}
#endif

void debug_printf(char *mesg, ...)
{
#ifdef DEBUG
	va_list vaargs;

	TABULATE
	va_start(vaargs, mesg);
	vfprintf(stderr, mesg, vaargs);
	va_end(vaargs);
#endif
}
