/*	store.c		*/
#include "header.h"

static int dndcount=0,dnditm=0;

static int form=FALSE;

static long outstanding_taxes=0;
static long dmg_taxes=0;

/*	this is the data for the stuff in the dnd store	*/
int maxitm=92;	/* number of items in the dnd inventory table	*/

struct _itm itm[92] = {
  /*cost	memory   iven name	iven arg      how
    gp	 	pointer  iven[]		ivenarg[]     many */
  { 2,		0,	OLEATHER,		0,	3	} ,
  { 10,		0,	OSTUDLEATHER,		0,	2	} ,
  { 40,		0,	ORING,			0,	2	} ,
  { 85,		0,	OCHAIN,			0,	2	} ,
  { 220,	0,	OSPLINT,		0,	1	} ,
  { 400,	0,	OPLATE,			0,	1	} ,
  { 900,	0,	OPLATEARMOR,		0,	1	} ,
  { 2600,	0,	OSSPLATE,		0,	1	} ,
  { 150,	0,	OSHIELD,		0,	1	} ,
  { 5000, 	0,      OELVENCHAIN,    	0,      0	} ,
  { 1000, 	0,	OORB,			0,	0	} ,
  { 10000,	0,	OSLAYER,		0,	0	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp	 	pointer	  iven[]	ivenarg[]  many */
  
  { 2,		0,	ODAGGER,		0,	3	} ,
  { 20,		0,	OSPEAR,			0,	3	} ,
  { 80,		0,	OFLAIL,			0,	2	} ,
  { 150,	0,	OBATTLEAXE,		0,	2	} ,
  { 450,	0,	OLONGSWORD,		0,	2	} ,
  { 1000,	0,	O2SWORD,		0,	2	} ,
  { 5000,	0,	OSWORD,			0,	1	} ,
  { 20000,	0,	OLANCE,			0,	1	} ,
  { 2000,	0,	OSWORDofSLASHING,	0,	0	} ,
  { 7500, 	0,	OHAMMER,		0,	0	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp	 	pointer	  iven[]	ivenarg[]  many */
  { 150,	0,	OPROTRING,		1,	1	} ,
  { 85,		0,	OSTRRING,		1,	1	} ,
  { 120,	0,	ODEXRING,		1,	1	} ,
  { 120,	0,	OCLEVERRING,		1,	1	} ,
  { 180,	0,	OENERGYRING,		0,	1	} ,
  { 125,	0,	ODAMRING,		0,	1	} ,
  { 220,	0,	OREGENRING,		0,	1	} ,
  { 1000,	0,	ORINGOFEXTRA,		0,	1	} ,
  
  { 280,	0,	OBELT,			0,	1	} ,
  { 400,	0,	OAMULET,		5,	1	} ,
  
  { 500,	0,	OCUBEofUNDEAD,		0,	0	} ,
  { 600,	0,	ONOTHEFT,		0,	0	} ,
  
  { 590,	0,	OCHEST,			3,	1	} ,
  { 200,	0,	OBOOK,			2,	1	} ,
  { 10,		0,	OCOOKIE,		0,	3	} ,
  { 666,  	0,	OHANDofFEAR,    	0,	0	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp	 	pointer	  iven[]	ivenarg[]  many */
  
  { 20,	   potionname,	OPOTION,		0,	6	} ,
  { 90,	   potionname,	OPOTION,		1,	5	} ,
  { 520,   potionname,	OPOTION,		2,	1	} ,
  { 100,   potionname,	OPOTION,		3,	2	} ,
  { 50,	   potionname,	OPOTION,		4,	2	} ,
  { 150,   potionname,	OPOTION,		5,	2	} ,
  { 70,	   potionname,	OPOTION,		6,	1	} ,
  { 30,	   potionname,	OPOTION,		7,	7	} ,
  { 200,   potionname,	OPOTION,		8,	1	} ,
  { 50,	   potionname,	OPOTION,		9,	1	} ,
  { 80,	   potionname,	OPOTION,		10,	1	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp	 	pointer	  iven[]	ivenarg[]  many */
  
  { 30,    potionname,	OPOTION,		11,	3	} ,
  { 20,	   potionname,	OPOTION,		12,	5	} ,
  { 40,	   potionname,	OPOTION,		13,	3	} ,
  { 35,	   potionname,	OPOTION,		14,	2	} ,
  { 520,   potionname,	OPOTION,		15,	1	} ,
  { 90,	   potionname,	OPOTION,		16,	2	} ,
  { 200,   potionname,	OPOTION,		17,	2	} ,
  { 220,   potionname,	OPOTION,		18,	4	} ,
  { 80,	   potionname,	OPOTION,		19,	6	} ,
  { 370,   potionname,	OPOTION,		20,	3	} ,
  { 50,	   potionname,	OPOTION,		22,	1	} ,
  { 150,   potionname,	OPOTION,		23,	15	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp	 	pointer	  iven[]	ivenarg[]  many */
  
  { 2750,  	0,	OORBOFDRAGON,		0,	0	} ,
  { 750,  	0,	OSPIRITSCARAB,		0,	0	} ,
  { 8000, 	0,	OVORPAL,		0,	0,	} ,
  
  { 100,   scrollname,	OSCROLL,		0,	2	} ,
  { 125,   scrollname,	OSCROLL,		1,	2	} ,
  { 60,    scrollname,	OSCROLL,		2,	4	} ,
  { 10,    scrollname,	OSCROLL,		3,	4	} ,
  { 100,   scrollname,	OSCROLL,		4,	3	} ,
  { 200,   scrollname,	OSCROLL,		5,	2	} ,
  { 110,   scrollname,	OSCROLL,		6,	1	} ,
  { 500,   scrollname,	OSCROLL,		7,	2	} ,
  { 200,   scrollname,	OSCROLL,		8,	2	} ,
  { 250,   scrollname,	OSCROLL,		9,	4	} ,
  { 20,	   scrollname,	OSCROLL,		10,	5	} ,
  { 30,	   scrollname,	OSCROLL,		11,	3	} ,
  
  /*cost	memory 	iven name	iven arg   how
    gp		pointer	  iven[]	ivenarg[]  many */
  
  { 340,  scrollname,	OSCROLL,		12,	1	} ,
  { 340,  scrollname,	OSCROLL,		13,	1	} ,
  { 300,  scrollname,	OSCROLL,		14,	2	} ,
  { 400,  scrollname,	OSCROLL,		15,	2	} ,
  { 500,  scrollname,	OSCROLL,		16,	2	} ,
  { 1000, scrollname,	OSCROLL,		17,	1	} ,
  { 500,  scrollname,	OSCROLL,		18,	1	} ,
  { 340,  scrollname,	OSCROLL,		19,	2	} ,
  { 220,  scrollname,	OSCROLL,		20,	3	} ,
  { 3900, scrollname,	OSCROLL,		21,	0	} ,
  { 610,  scrollname,	OSCROLL,		22,	1	} ,
  { 3000, scrollname,	OSCROLL,		23,	0	} ,
  { 300,  0,		OSPHTALISMAN,   	0,	0	} ,
  { 150,  0,		OWWAND,			0,	0	} ,
  { 50,	  0,		OBRASSLAMP,		0,	0	} ,
  { 9500, 0,		OPSTAFF,		0,	0	} 
};

press_any()
{
  lprcat("Press any key to continue");
  lflush();
  (void) getcharacter();
}

press_esc()
{
  lprcat("\nPress "); 
  standout("Esc"); 
  lprcat(" to leave: "); 
  lflush();
  do { } while ( getcharacter() != '\33' );
}

/*
  function for the dnd store
  */
dnd_2hed()
{
  lprcat("Welcome to the Ularn Thrift Shoppe.  We stock many items explorers find useful\n");
  lprcat("in their adventures.  Feel free to browse to your hearts content.\n");
  lprcat("Also be advised, if you break 'em, you pay for 'em.");
}

dnd_hed()
{
  register int i;
  
  for (i=dnditm; i<26+dnditm; i++)	
    dnditem(i);
  cursor(50,18); 
  lprcat("You have ");
}

dndstore()
{
  register int i;
  
  dnditm = 0;
  nosignal = 1; /* disable signals */
  clear();  
  dnd_2hed();
  if (outstanding_taxes>0) 
  {
    lprcat("\n\nThe Ularn Revenue Service has ordered us to not do business with tax evaders.\n"); 
    beep();
    lprintf("They have also told us that you owe %d gp in back taxes, and as we must\n",(long)outstanding_taxes);
    lprcat("comply with the law, we cannot serve you at this time.  Soo Sorry.\n");
    cursors();	
    lprcat("\nPress "); 
    standout("Esc"); 
    lprcat(" to leave: "); 
    lflush();
    do {} while ('\33' != getcharacter());
  }else{
    dnd_hed();
    do {
      cursor(59,18); 
      lprintf("%d gold pieces",(long)c[GOLD]);
      cltoeoln(); 
      cl_dn(1,20);	/* erase to eod */
      lprcat("\nYour choice ["); 
      standout("space");
      lprcat("/");
      standout("Tab");
      lprcat(" for next/previous screen, "); 
      standout("Esc");
      lprcat(" to leave]? ");
      do {
	i=getcharacter();
      } while ( (i<'a' || i>'z') && (i!=' ') && (i!='\t') && (i!='\33') && (i!=12) );  
      if (i==12) { 
	clear();  
	dnd_2hed();  
	dnd_hed(); 
      }else if (i=='\33') { 	
      }else if (i==' ') {
	cl_dn(1,4);
	if ((dnditm += 26) >= maxitm) 
	  dnditm=0; 
	dnd_hed();
      }else if (i=='\t') {
	cl_dn(1, 4);
	if ((dnditm -= 26) < 0) 
	  dnditm = (maxitm / 26) * 26; 
	dnd_hed();
      }else{                            /* buy something */
	lprc(i);                	/* echo the byte */
	i += dnditm - 'a';
	if (i>=maxitm) 
	  outofstock(); 
	else if (itm[i].qty <= 0) 
	  outofstock(); 
	else if (pocketfull()) 
	  handsfull(); 
	else if (c[GOLD] < itm[i].price*10L) 
	  nogold(); 
	else { 	
	  if (itm[i].mem != 0) 
	    *itm[i].mem[itm[i].arg] = ' ';
	  c[GOLD] -= itm[i].price*10L;
	  itm[i].qty--;  
	  take(itm[i].obj,itm[i].arg);
	  if (itm[i].qty==0) 
	    dnditem(i);  
	  nap(1001);
	};
      };
    } while ( i != '\33' );
  };
  drawscreen();  
  nosignal = 0; /* enable signals */
}
/*
  function for the players hands are full
  */
handsfull()
{ 	
  lprcat("\nYou can't carry anything more!"); 
  lflush(); 
  nap(2200); 
}
outofstock()
{ 	
  lprcat("\nSorry, but we are out of that item."); 
  lflush(); 
  nap(2200); 
}
nogold()
{ 	
  lprcat("\nYou don't have enough gold to pay for that!"); 
  lflush(); 
  nap(2200); 
}

/*
  dnditem(index)
  
  to print the item list;  
  used in dndstore() enter with the index into itm
  */
dnditem(i)
     register int i;
{
  register int j,k;
  
  if (i >= maxitm)  
    return;
  cursor( (j=(i&1)*40+1) , (k=((i%26)>>1)+5) );
  if (itm[i].qty == 0)  { 	
    lprintf("%39s","");  
    return; 
  }
  lprintf("%c) ",(i%26)+'a');
  if (itm[i].obj == OPOTION) { 	
    lprcat("potion of "); 
    lprintf("%s",&potionname[itm[i].arg][1]); 
  }
  else if (itm[i].obj == OSCROLL) { 	
    lprcat("scroll of "); 
    lprintf("%s",&scrollname[itm[i].arg][1]); 
  }
  else lprintf("%s",objectname[itm[i].obj]);
  cursor( j+31,k );  
  lprintf("%6d",((long)itm[i].price*10));
}

/*
  for the college of larn
  */

typedef struct COURSETAG {
  int taken;
  int time;
  char *text;
} COURSE;

static char *kopfzl[] = { 
           {"The College of Ularn offers the exciting opportunity of higher education to\n"}
          ,{"all inhabitants of the caves.  Here is a list of the class schedule:\n\n\n"}
          ,{"\t\t    Course Name                Time Needed\n\n"}
};
static COURSE  courses[] = {
   {0, 10, {"\t\ta)  Fighters Training I         %2d mobuls"}}
  ,{0, 15, {"\t\tb)  Fighters Training II        %2d mobuls"}}
  ,{0, 10, {"\t\tc)  Introduction to Wizardry    %2d mobuls"}}
  ,{0, 20, {"\t\td)  Applied Wizardry            %2d mobuls"}}
  ,{0, 10, {"\t\te)  Behavioral Psychology       %2d mobuls"}}
  ,{0, 10, {"\t\tf)  Faith for Today             %2d mobuls"}}
  ,{0, 10, {"\t\tg)  Contemporary Dance          %2d mobuls"}}
  ,{0,  5, {"\t\th)  History of Ularn            %2d mobuls"}}
};

/*
 * get & restore courses[].taken for saveobj.c
 */

int get_taken(n_elem, ch_ptr)
     int n_elem;
     char *ch_ptr;
{
  int i, n;
  
  n = min(n_elem, N_ELEM(courses));
  for(i=0; i < n; i++){
    ch_ptr[i] = courses[i].taken;
  };
  return(n);
}

int rest_taken(n_elem, ch_ptr)
     int n_elem;
     char *ch_ptr;
{
  int i, n;
  
  n = min(n_elem, N_ELEM(courses));
  for(i=0; i < n; i++){
    courses[i].taken = ch_ptr[i];
  };
  return(n);
}


/*
  function to display the header info for the school
  */
sch_hed()
{
  int i;
  
  clear();
  lprcat(kopfzl[0]);
  lprcat(kopfzl[1]);
  lprcat(kopfzl[2]);
  
  /*at line 7 of crt*/
  for (i=0; i < (sizeof(courses) / sizeof(courses[0])); i++){
    if (courses[i].taken == 0){ 
      lprintf(courses[i].text, courses[i].time);
    };
    lprc('\n');
  };
  lprcat("\n\t\tEach course costs 250 gold pieces.");
  cursor(30, 18);
  lprcat("You are presently carrying ");
}

oschool()
{
  register int i, inx, took_it;
  long time_used;
  
  nosignal = 1; /* disable signals */
  sch_hed();
  do {
    cursor(57,18); 
    lprintf("%d gold pieces.   ",(long)c[GOLD]); 
    cursors();
    lprcat("\nWhat is your choice ["); 
    standout("Esc");
    lprcat(" to leave] ? ");  
    yrepcount=0;
    do {
      i=getcharacter();
    } while ( (i<'a' || i>'h') && (i!='\33') && (i!=12) ) ;
    inx = i -'a';
    if (i == 12) { 
      sch_hed();  
    }else if (i != '\33') {
      lprc(i);
      if (c[GOLD] < 250){  
	nogold();  
      }else if (courses[inx].taken) { 	
	lprcat("\nSorry, but that class is filled."); 
      }else if (i <= 'h') {
	took_it = TRUE;
	switch(i) {
	case 'a':
	  c[STRENGTH] += 2;  
	  c[CONSTITUTION]++;
	  lprcat("\nYou feel stronger!");
	  cl_line(16,7);
	  break;
	  
	case 'b':
	  if ( ! courses[0].taken ) {
	    lprcat("\nSorry, but this class has a prerequisite of Fighters Training I");
	    took_it = FALSE;
	  }else{
	    lprcat("\nYou feel much stronger!");
	    cl_line(16,8);
	    c[STRENGTH] += 2;  
	    c[CONSTITUTION] += 2;  
	  };
	  break;
	  
	case 'c':
	  c[INTELLIGENCE] += 2; 
	  lprcat("\nThe task before you now seems more attainable!");
	  cl_line(16,9);  
	  break;
	  
	case 'd':
	  if ( ! courses[2].taken ) {
	    lprcat("\nSorry, but this class has a prerequisite of Introduction to Wizardry");
	    took_it = FALSE;
	  }else{
	    lprcat("\nThe task before you now seems very attainable!");
	    cl_line(16,10);
	    c[INTELLIGENCE] += 2;  
	  };
	  break;
	  
	case 'e':
	  c[CHARISMA] += 3;  
	  lprcat("\nYou now feel like a born leader!");
	  cl_line(16,11);  
	  break;
	  
	case 'f':
	  c[WISDOM] += 2;  
	  lprcat("\nYou now feel more confident that you can find the potion in time!");
	  cl_line(16,12);  
	  break;
	  
	case 'g':
	  c[DEXTERITY] += 3;  
	  lprcat("\nYou feel like dancing!");
	  cl_line(16,13);  
	  break;
	  
	case 'h':
	  c[INTELLIGENCE]++;
	  lprcat("\nWow!! E = MC^2!!!\n");
	  cl_line(16,14);  
	  break;
	};
	if ( took_it > 0 ) {
	  c[GOLD] -= 250; 
	  time_used = courses[inx].time *100;
	  gtime +=  time_used;
	  courses[inx].taken++; 	      /* remember that s/he has taken that course */
	  c[HP] = c[HPMAX];           	      /* s/he regenerated : */ 
	  c[SPELLS] = c[SPELLMAX]; 
	  
	  if (c[BLINDCOUNT])       	      /* cure blindness too!  */
	    c[BLINDCOUNT]=1;  
	  
	  if (c[CONFUSE])		      /*	end confusion	*/
	    c[CONFUSE]=1;	
	  
	  adjtime((long)time_used);	      /* adjust parameters for time change */
	};
      };
      nap(1000);
    }
  } while ( i != '\33' );
  nosignal = 0; 
  drawscreen();  /* enable signals */
}

/*
 *	for the first national bank of Ularn
 */
long lasttime=0;	/* last time he was in bank */
obank(on_ground)
int on_ground;
{
  long amt;
  int i;

  nosignal = 1; /* disable signals */
  bank_hdr(on_ground);
  if (outstanding_taxes>0) {
    lprcat("\n\nThe Ularn Revenue Service has ordered that your account be frozen until all\n"); 
    lprintf("levied taxes of %d gp have been paid. \n\n", (long)outstanding_taxes);
    if ( form ) {
      lprcat("I see that you brought a signed form along authorizing us to transfer\n");
      lprcat("up to 4095 gp from your account to theirs.\n");
      amt = min(4095, min(c[BANKACCOUNT], outstanding_taxes));
      lflush();
      nap(2200);
      addtax( -amt, TRUE );
      scoretaxes(outstanding_taxes, dmg_taxes);
      c[BANKACCOUNT] -= amt;
      form = FALSE;
      lprintf("\nWe transferred %d gp to %s leaving %d gp on your account.\n", 
	      amt, objectname[OLRS], c[BANKACCOUNT]);
      if ( outstanding_taxes <= 0 ){
	press_any();
	bank_hdr(on_ground);
	obanksub();
      }else{
	press_esc();
      };
    }else{
      beep();
      lprcat("We must comply with them and cannot serve you at this time.  Sorry.\n");
      lprcat("We suggest you go to the LRS office and pay your taxes.\n");
      press_esc();
    }; 
  }else{
    obanksub();
  };		
  drawscreen();
  nosignal = 0; /* enable signals */
}

bank_hdr(on_ground)
int on_ground;
{
  clear();  
  lprcat( on_ground 
            ? "    Welcome to the First National Bank of Ularn."
            : "Welcome to the 8th level branch office of the First National Bank of Ularn."
	 );
}


/*
 *	function to put interest on your bank account
 */
ointerest()
{
  register int i;
  
  if (c[BANKACCOUNT]<0) 
    c[BANKACCOUNT] = 0;
  else if ((c[BANKACCOUNT]>0) && (c[BANKACCOUNT]<1000000)) {
    i = (gtime-lasttime)/100; /* # mobuls elapsed */
    while ((i-- > 0) && (c[BANKACCOUNT]<1000000))
      c[BANKACCOUNT] += c[BANKACCOUNT]/250;
    if (c[BANKACCOUNT]>1000000) 
      c[BANKACCOUNT]=1000000; /* interest limit */
  }
  lasttime = (gtime/100)*100;
}

static short gemorder[NINVT]={0};	/* the reference to screen location for each */
static long gemvalue[NINVT]={0};	/* the appraisal of the gems */

obanksub()
{
  long amt;
  register int i,k;
  ointerest();	/* credit any needed interest */
  
  lprcat("\n\n\tGemstone\t      Appraisal\t\tGemstone\t      Appraisal");

  if (level==8) c[TELEFLAG] = 0;
  
  for(i = 0; i < NINVT; i++)
    gemvalue[i] = 0;
  
  for (k=i=0; i < NINVT; i++)
    switch(iven[i]) {
    case OLARNEYE: 
    case ODIAMOND: 
    case OEMERALD: 
    case ORUBY: 
    case OSAPPHIRE: 
      if (iven[i]==OLARNEYE) { 	
	gemvalue[i]=250000-((gtime*7)/100)*100;
	if (gemvalue[i]<50000) 
	  gemvalue[i]=50000;
      }
      else gemvalue[i] = (255&ivenarg[i])*100;
      gemorder[i]=k;
      cursor( (k%2)*40+1 , (k>>1)+4 );
      lprintf("%c) %s",i+'a',objectname[iven[i]]);
      cursor( (k%2)*40+33 , (k>>1)+4 );
      lprintf("%5d",(long)gemvalue[i]);  
      k++;
    };
  cursor(31,17); 
  lprintf("You have %8d gold pieces in the bank.",(long)c[BANKACCOUNT]);
  cursor(40,18); 
  lprintf("You have %8d gold pieces",(long)c[GOLD]);
  if (c[BANKACCOUNT]+c[GOLD] >= 500000)
    lprcat("\nNote:  Ularndom law states that only deposits under 1,000,000gp  can earn interest.");
  while (1) {
    cl_dn(1,20);
    lprcat("\nYour wish? [("); 
    standout("d"); 
    lprcat(") deposit, (");
    standout("w"); 
    lprcat(") withdraw, ("); 
    standout("s");
    lprcat(") sell a stone, or "); 
    standout("Esc"); 
    lprcat("]  ");
    yrepcount=0;
    i=getvfdchar("dDwWsS\33");
    switch(i) {
    case 'd':
    case 'D':
      lprcat("deposit\nHow much? ");	
      amt = readnum((long)c[GOLD]);
      if (amt < 0) { 
	lprcat("\nSorry, but our computer doesn't let us take negative gold!"); 
	nap(2000); 
	amt=0; 
      } 
      else if (amt>c[GOLD]) { 	
	lprcat("  You don't have that much."); 
	nap(2000); 
      } 
      else { 	
	c[GOLD] -= amt;  
	c[BANKACCOUNT] += amt; 
      }
      break;
      
    case 'w':
    case 'W':
      lprcat("withdraw\nHow much? ");	
      amt = readnum((long)c[BANKACCOUNT]);
      if (amt<0) { 	
	lprcat("\nSorry, but our computer doesn't let us issue negative gold!");  
	nap(2000); 
	amt=0; 
      }
      else if (amt > c[BANKACCOUNT]) { 	
	lprcat("\nYou don't have that much in the bank!"); 
	nap(2000); 
      }
      else { 	
	c[GOLD] += amt;  
	c[BANKACCOUNT] -= amt; 
      }		
      break;
      
    case 's':
    case 'S':
      lprcat("\nWhich stone would you like to sell? ");
      do { 
	i=getcharacter();
      } while ((i<'a' || i>'z') && i!='*') ;
      if (i=='*'){
	for (i=0; i < NINVT; i++) { 	
	  if (gemvalue[i]) {
	    sellstone(i);
	  };
	};
      } else { 
	k=i-'a';
	if (gemvalue[k]==0) {
	  lprintf("\nItem %c is not a gemstone!",i);
	  nap(2000); 
	}else{
	  sellstone(k);
	};
      }
      break;
    case '\33':
      return;
    };
    cursor(40,17); 
    lprintf("%8d",(long)c[BANKACCOUNT]);
    cursor(49,18); 
    lprintf("%8d",(long)c[GOLD]);
  }
}

sellstone(i)
     int i;
{
     char d;
     int  k;

     if (iven[i]==OLARNEYE) {
       d = objnamelist[0];
       monstnamelist[DEMONLORD  ]=d;
       monstnamelist[DEMONLORD+1]=d;
       monstnamelist[DEMONLORD+2]=d;
       monstnamelist[DEMONLORD+3]=d;
       monstnamelist[DEMONLORD+4]=d;
       monstnamelist[DEMONLORD+5]=d;
       monstnamelist[DEMONLORD+6]=d;
       monstnamelist[DEMONPRINCE]=d;
       monstnamelist[LUCIFER]    =d;
     };
     c[GOLD]+=gemvalue[i];  
     iven[i]=0;
     gemvalue[i]=0;	
     k = gemorder[i];
     cursor( (k%2)*40+1 , (k>>1)+4 );
     lprintf("%39s","");
}


#if 0          /* ws, 07.08.1993 */
/*
  subroutine to appraise any stone for the bank
  */

appraise(gemstone)
     int gemstone;
{
  register int j;
  register long amt;
  
  for (j=0; j < NINVT; j++)
    if (iven[j]==gemstone) {
      lprintf("\nI see you have %s",objectname[gemstone]);
      if (gemstone==OLARNEYE) 
	lprcat("  I must commend you.  I didn't think\nyou could get it.");
      lprcat("  Shall I appraise it for you? ");  
      yrepcount=0;
      if (getyn()=='y') {
	lprcat("yes.\n  Just one moment please \n");  
	nap(1000);
	if (gemstone==OLARNEYE) {
	  amt = 250000-((gtime*7)/100)*100;
	  if (amt<50000) amt=50000;
	}
	else amt = (255 & ivenarg[j]) * 100;
	lprintf("\nI can see this is an excellent stone, It is worth %d",(long)amt);
	lprcat("\nWould you like to sell it to us? ");  
	yrepcount=0;
	if (getyn()=='y') { 
	  lprcat("yes\n"); 
	  c[GOLD]+=amt;  
	  iven[j]=0; 
	}
	else lprcat("no thank you.\n");
	if (gemstone==OLARNEYE) lprcat("It is, of course, your privilege to keep the stone\n"); 
      }
      else lprcat("no\nO. K.\n");
    }
}
#endif

/*
  function for the trading post
  */
otradhead()
{
  clear();
  lprcat("Welcome to the Ularn Trading Post.  We buy items that explorers no longer find\n");
  lprcat("useful.  Since the condition of the items you bring in is not certain,\n");
  lprcat("and we incur great expense in reconditioning the items, we usually pay\n");
  lprcat("only 20% of their value were they to be new.  If the items are badly\n");
  lprcat("damaged, we will pay only 10% of their new value.\n\n");
}

otradepost()
{
  int i,j,isub,izarg;
  long value;
  
  dnditm = dndcount = 0;
  nosignal = 1; /* disable signals */
  resetscroll();	
  otradhead();
  do {
    lprcat("\nWhat item do you want to sell to us ["); 
    standout("*");
    lprcat(" for list, or "); 
    standout("Esc"); 
    lprcat(" to leave] ? ");
    do {
      i=getcharacter();
    } while ( ! ( ((i<='z') && (i>='a'))  || (i=='.') || (i=='*') || (i=='\33') ) );
    
    if (i=='*') { 	
      clear(); 
      i = qshowstr(1); 
      otradhead();
    };
    
    if (i != '\33') {
      isub = i - 'a';		
      if ( ((iven[isub]==OSCROLL) && (scrollname[ivenarg[isub]][0]==0)) 
	  ||
	  ((iven[isub]==OPOTION) && (potionname[ivenarg[isub]][0]==0)) ) 
      { 	
	lprcat("\nSorry, we can't accept unidentified objects.");
      }else if ( i == 0x20 ){
	/* nothing */
      }else if (iven[isub]==0){  
	lprintf("\nYou don't have item %c!",isub+'a');
      }else{
	value = -1;
	if (   (iven[isub] == ODIAMOND) 
	    || (iven[isub] == ORUBY) 
	    || (iven[isub] == OEMERALD) 
	    || (iven[isub] == OSAPPHIRE) ){
	  value = 20*ivenarg[isub];
	}else{
	  for (j=0; (j < maxitm) && (value < 0) ; j++){
	    if ( itm[j].obj == iven[isub] ){ 
	      if ( (itm[j].obj == OSCROLL) || (itm[j].obj == OPOTION) ){ 
		value = 2*itm[j+ivenarg[isub]].price;
	      }else{
		izarg=ivenarg[isub];  
		/* appreciate if a +n object */
		value = itm[j].price;	
		if (izarg >= 0) value *= 2;
		while ((izarg-- > 0) && ((value=14*(67+value)/10) < 500000));
	      };
	    };
	  };
	};
	if ( value < 0 ){
	  lprcat("\nSo sorry, but we are not authorized to accept that item.");
	}else{
	  srcount=0;  
	  (void) show3(isub, 0);	/* show what the item was */
	  lprintf("\nItem (%c) is worth %d gold pieces to us.  Do you want to sell it? ",i,(long)value);
	  yrepcount=0;
	  if (getyn()=='y') {
	    lprcat("yes\n"); 
	    c[GOLD]+=value;
	    if (c[WEAR] == isub) c[WEAR] = -1;
	    if (c[WIELD] == isub) c[WIELD] = -1;
	    if (c[SHIELD] == isub) c[SHIELD] = -1;
	    adjustcvalues(iven[isub],ivenarg[isub]);
	    iven[isub]=0;
	  }else{
	    lprcat("no thanks.\n");
	  };
	};
      };
    };
  } while ( i != '\33' );
  setscroll(); 
  recalc(); 
  drawscreen(); 
  nosignal=0; /* enable signals */
}

/*
 *	for the Ularn Revenue Service
 */
olrs()
{
  register int i, j;
  
  nosignal = 1; /* disable signals */
  clear();  
  resetscroll(); 
  cursor(1,4);
  if (outstanding_taxes && cheat) {
    lprcat("Sorry, but it seems you are trying to pay off your taxes by cheating!");
    lprcat("\n\n\tpress ");
    standout("Esc");
    lprcat(" to exit the office.");
    cursors();
    do { } while ( (getcharacter() != '\33') );
  }else{
    lprcat("Welcome to the Ularn Revenue Service district office.  How can we help you?");
    do {
      for (j=6; j <= 12; j++ ){ 
	cl_line(1, j);
      };
      cursor(1,6);
      printtax();
      cursor(1,7);
      if( dmg_taxes > 0){
	lprintf("Of these, %d gp to repair damages to this building which you caused.  "
	      , (long) dmg_taxes );
      };
      cursor(1,9);
      lprintf ( c[GOLD] > 0 
	       ? "You have %d gp.    "
	       : "You have no gold pieces.  "
	       ,(long) c[GOLD] );
      cursor(1, 12);
      lprcat("Your wish? [");
      if ( outstanding_taxes ){
	standout("p");
	lprcat(" pay taxes");
	if ( form ){
	  lprcat(" ");
	}else{
	  lprcat(", ");
	  standout("b");
	  lprcat(" transfer money from your bank account, ");
	};
	lprcat("or ");
      };
      standout("Esc");
      lprcat("]  ");  
      yrepcount=0;
      i = getvfdchar( outstanding_taxes == 0 
		     ? "\33"  
		     : form ? "pP\33" : "pPbB\33" );
      switch(i){
      case 'p':
      case 'P':
	lprcat("pay taxes");
	cl_dn(1, 13);
	cursor(1, 13);
	lprcat("\nHow much? "); 
	pay_direct();
	break;
      case 'b':
      case 'B':
	cl_dn(1, 13);
	cursor(1, 13);
	bank_xfer();
	break;
      };
    } while ( i != '\33' ) ;
  };
  setscroll(); 
  drawscreen();	
  nosignal = 0; /* enable signals */
}


pay_direct()
{
  long amt;

  amt = readnum((long)c[GOLD]);
  if (amt < 0) { 
    lprcat("\nSorry, but we can't take negative gold\n"); 
  }else if ( amt > c[GOLD] ){	
    lprcat("  You don't have that much.\n");
  }else{
    amt      = min(amt, outstanding_taxes);
    addtax( -amt, TRUE );
    scoretaxes(outstanding_taxes, dmg_taxes);
    c[GOLD] -= amt;
    nap(2200);
  };
  lflush();
};


bank_xfer()
{
  long amt;

  lprcat("\nJust a second while I phone them ... ");
  nap(3200);
  if ( rund(86) < 45 ){
    lprcat("Sorry, but their line's engaged\n");
  }else{
    nap(2200);
    if ( rund(20) < 11 ){
      lprcat("\n\nThey don't trust people on the telephone. You will have to go over to them"); 
      lprcat("\nand appear in person. I'll give you this form to fillout for them.\n");
      lflush();
      form = TRUE;
      nap(2200);
    }else if ( rund(20) < 10 ){
      beep();
      lprintf("These $%& computers are down again!\n");
    }else{
      amt = min(c[BANKACCOUNT], outstanding_taxes);
      lprintf("\n\nThey transferred %d gp to %s\n", amt, objectname[OLRS]);
      addtax( -amt, TRUE );
      scoretaxes(outstanding_taxes, dmg_taxes);
      c[BANKACCOUNT] -= amt;
    }
  };
  lflush();
}

printtax()
{
  lprintf( outstanding_taxes > 0 
            ? "You presently owe %d gp to %s.  "
	    : "You do not owe us any taxes.           "
	  , (long) outstanding_taxes 
	  , objectname[OLRS] );
  
}

settax(ltax, is_dmg)
long ltax;
int  is_dmg;
{
  ltax = max( 0, ltax );
  if ( is_dmg ){
    dmg_taxes = ltax;
  }else{
    outstanding_taxes = ltax;
  };
}

addtax(ltax, is_dmg)
long ltax;
int  is_dmg;
{
  outstanding_taxes += ltax;
  outstanding_taxes  = max(0, outstanding_taxes);
  if ( is_dmg ){
    dmg_taxes += ltax;
    dmg_taxes  = max( 0, dmg_taxes );
  };
}

long gettax(is_dmg)
int  is_dmg;
{
  return ( is_dmg ? dmg_taxes : outstanding_taxes );
}

/*
  Dealer McDopes Pad
  */

typedef struct DRUGSTAG {
  int taken;
  int type;
  int price;
  char *text;
} DRUGS;

static char *drugs_kopfzl[] = { 
  {"Hey %s, welcome to Dealer McDope's Pad!  I gots the some of the finest shit\n"}
  ,{ "you'll find anywhere in Ularn - check it out...\n\n\n"}
                     ,{"\t\t    The Stash\t\t\tThe Cash\n\n"}
};
static DRUGS  drugs[] = {
  {0, OSPEED,    100, {"\t\ta)  Killer Speed\t\t%4d bucks"}}
 ,{0, OACID,     250, {"\t\tb)  Groovy Acid\t\t\t%4d bucks"}}
 ,{0, OHASH,     500, {"\t\tc)  Monster Hash\t\t%4d bucks"}}
 ,{0, OSHROOMS, 1000, {"\t\td)  Trippy Shrooms\t\t%4d bucks"}}
 ,{0, OCOKE,    5000, {"\t\te)  Cool Coke\t\t\t%4d bucks"}}
};

/*
  function to display the header info for the pad
  */
pad_hd()
{
  int i;

  clear();
  lprintf(drugs_kopfzl[0], is_male ? "man" : "chick");
  lprcat(drugs_kopfzl[1]);
  lprcat(drugs_kopfzl[2]);
  
  /*line 7 of crt*/
  for (i=0; i < N_ELEM(drugs); i++){
    if (drugs[i].taken == 0) lprintf(drugs[i].text, drugs[i].price);
    lprc('\n');
  };
}

opad()
{
  register int i, inx;
  
  nosignal = 1; /* disable signals */
  
  pad_hd();
  
  do {
    cursor(30,18);
    lprintf("Looks like ya got 'bout %d bucks on you.   ",(long)c[GOLD]); 
    cursors();
    lprcat("\nSo, whatdya want [esc");
    lprcat(" to split] ? ");  
    yrepcount=0;
    
    do {
      i=getcharacter();
    } while ( (i<'a' || i>'e') && (i!='\33') && (i!=12) );
    inx = i - 'a';
    
    if (i==12) { 
      pad_hd();  
    }else if ( i !='\33' ) {
      lprc(i);
      if (drugs[inx].taken) { 	
	nomore();
      }else if ( c[GOLD] < drugs[inx].price ){
	nocash();
      }else if ( snag(drugs[inx].type) ) {
	c[GOLD] -= drugs[inx].price; 
	drugs[inx].taken++;
	cl_line(16,7+inx);
      };
      nap(1000);
    };
  } while ( i != '\33' );
  drawscreen();  /* enable signals */
  nosignal = 0; 
}


nomore()
{
  lprcat("\nSorry man, I ain't got no more of that shit.");
  lflush(); 
  nap(1200); 
}
nocash()
{ 	
  lprcat("\nWhattaya trying to pull on me? You aint got the cash!");
  lflush(); 
  nap(1200);
}

snag(itm)
     int itm;
{
  int i,limit;
  
  if ( (limit = 15 + (c[LEVEL] >> 1)) > NINVT) limit=NINVT;
  
  for(i=0;i<limit;i++)
    if (iven[i]==0) {
      iven[i]=itm;
      ivenarg[i]=0;
      lprcat("\nOk, here ya go");
      (void) show3(i, 0);
      return(1);
    }
  lprcat("\nHey, you can't carry anymore");
  return(0);
}













