#include <sys/time.h>

iwait(f, timeout)
	unsigned long timeout;	/* in seconds */
/*
 * Wait until 'f' is ready for reading, or 'timeout'.
 * Return '>=0' when 'f' is readable, '0' if timeout, '-1' on error.
 * Example: 'iwait(f,0)' polls a file descriptor
 * without blocking and returns true if it's readable;
 * 'iwait(0,0)' returns true when standard input is available.
 */
{
	struct timeval t;
	int readfd = 1<<f;

	t.tv_sec = timeout, t.tv_usec = 0;
	return select(sizeof(int)*8,  &readfd, (int *)0, (int *)0, &t);
}
