#include <stdio.h>
#include <midi.h>
#include <dx7voice.h>

Dx7Voice *
dx7GetVoice(midi,channel,n)
/*
** Read and return the dx7 voice from program 'n' in the dx7,
** or '0' if something went wrong.
** 'n' is 0-based; if 'n != -1', the dx7 current voice is set to 'n'.
** The dx7 must be in cs{SYS INFO AVAIL} mode (see 'dx7SysInfoAvail()').
** 'midi' is the midi file descriptor, with cs{MPU_EXCLUSIVE_TO_HOST} enabled.
** See the tag 'Mvget' for an example.
** 'dx7GetVoice()' flushes out some MIDI data until it sees a voice;
** there are currently no real checks to make sure this works,
** so it's possible to hang busy waiting in here,
** or have unread data lying around.
*/
{
	char c[5];
	Dx7Voice *v = (Dx7Voice *)0, *dx7readVoice();

	if (n != -1) dx7SetVoice(midi,channel,n);
		/* wait for the next SX_CMD to show up */
	while (read(midi,c,1)==1 && (unsigned char) *c != SX_CMD) ;
		/* skip header (next 5 bytes) up to start of block */
	if (read(midi,c,5) != 5)
		return MidiError("dx7GetVoice: huh?\n"), v;
	v = Alloc(Dx7Voice);
	if (!v) return MidiError("wha th-- no memory!\n"),v;

	if (read(midi,v,SizeofDx7Voice) != SizeofDx7Voice)
		MidiError("dx7GetVoice: read error\n");

	v->name[10] = '\0';
	return v;
}
