                                                  /*                AIFF.C    */
#include	"cs.h"
#include	"soundio.h"
#include	"aiff.h"
#include	<sfheader.h>
#include	<math.h>

#define TRUE    1
#define FALSE   0
#define DEBUG	1

static char     FORM_ID[4] = {'F','O','R','M'};
static char     COMM_ID[4] = {'C','O','M','M'};
static char     MARK_ID[4] = {'M','A','R','K'};
static char     INST_ID[4] = {'I','N','S','T'};
static char     SSND_ID[4] = {'S','S','N','D'};
static char     FORM_TYPE[4] = {'A','I','F','F'};

static FormHdr	    form;
static CommChunk1   comm1;   /* CommonChunk split    */
static CommChunk2   comm2;   /*  to avoid xtra space */
static SoundDataHdr ssnd;

static int sizFormHdr = sizeof(FormHdr);
static int sizCommChunk1 = sizeof(CkHdr) + sizeof(short); /* to avoid long roundup */
static int sizCommChunk2 = sizeof(CommChunk2);
static int sizSoundDataHdr = sizeof(SoundDataHdr);
static int samp_size;
static int aiffhdrsiz = sizeof(FormHdr)
                      + sizeof(CkHdr) + sizeof(short)
                      + sizeof(CommChunk2)
                      + sizeof(SoundDataHdr);

int bytrevhost()
{
    return(*(long *)FORM_ID != 'FORM');
}

static short benshort(sval)    /* coerce a natural short into a bigendian short */
  register short sval;
{
    char  benchar[2];
    register char *p = benchar;

    *p++ = 0xFF & (sval >> 8);
    *p   = 0xFF & sval;
    return(*(short *)benchar);
}

static long benlong(lval)      /* coerce a natural long into a bigendian long */
  register long lval;
{
    char  benchar[4];
    register char *p = benchar;

    *p++ = 0xFF & (lval >> 24);
    *p++ = 0xFF & (lval >> 16);
    *p++ = 0xFF & (lval >> 8);
    *p   = 0xFF & lval;
    return(*(long *)benchar);
}

short natshort(sval)          /* coerce a bigendian short into a natural short */
  short sval;
{
    unsigned char benchar[2];
    register short natshort;

    *(short *)benchar = sval;
    natshort = benchar[0];
    natshort <<= 8;
    natshort |= benchar[1];
    return(natshort);
}

long natlong(lval)             /* coerce a bigendian long into a natural long */
  long lval;
{
    unsigned char benchar[4];
    register unsigned char *p = benchar;
    register long natlong;

    *(long *)benchar = lval;
    natlong = *p++;
    natlong <<= 8;
    natlong |= *p++;
    natlong <<= 8;
    natlong |= *p++;
    natlong <<= 8;
    natlong |= *p;
    return(natlong);
}

void aiffWriteHdr(fd,sampsize,nchls,sr) /* Write AIFF header at start of file.    */
  int fd;               		/* Called after open, before data writes  */
  int sampsize; /* sample size in bytes */
  int nchls;
  double sr;	/* sampling rate */
{
#if DEBUG
	printf("aiffWriteHdr: fd %d sampsize %d nchls %d sr %lf\n",
		fd,sampsize,nchls,sr);
#endif
	samp_size = sampsize;
	form.ckHdr.ckID = *(long *) FORM_ID;
	form.ckHdr.ckSize = 0;  		/* leave for aiffReWriteHdr */
	form.formType = *(long *) FORM_TYPE;
	comm1.ckHdr.ckID = *(long *) COMM_ID;
	comm1.ckHdr.ckSize = benlong((long)sizeof(short) + sizCommChunk2);
	comm1.numChannels = benshort((short)nchls);
        comm2.numSampleFrames = 0;	        /* leave for aiffReWriteHdr */
	comm2.sampleSize = benshort((short)(sampsize * 8));
	double_to_ieee_80(sr,comm2.sampleRate);  /* insert 80-bit srate */
	ssnd.ckHdr.ckID = *(long *) SSND_ID;
	ssnd.ckHdr.ckSize = 0;  		/* leave for aiffReWriteHdr */
	ssnd.offset = 0;
	ssnd.blockSize = 0;

	if ( write(fd, &form, sizFormHdr) != sizFormHdr
	  || write(fd, &comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, &comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, &ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	    die("error writing AIFF header");
}
             
void aiffReWriteHdr(fd)            /* Write proper sizes into AIFF header  */
  int fd;                          /*         Called before closing file.  */
{
        long endpos;
	long numsamps;
	long ssnd_size;
	long form_size;
#if DEBUG
	printf("aiffReWriteHdr: fd %d\n", fd);
#endif
	endpos = tell(fd);
	numsamps = (endpos - aiffhdrsiz) / samp_size;
	ssnd_size = (endpos - aiffhdrsiz) + 2 * sizeof(long);
	form_size = endpos - sizeof(CkHdr);
#if DEBUG
	printf("endpos %lx numsamps %lx ssnd_size %lx form_size %lx\n",
		endpos, numsamps, ssnd_size, form_size);
#endif
	form.ckHdr.ckSize = benlong(form_size);
	comm2.numSampleFrames = benlong(numsamps);
	ssnd.ckHdr.ckSize = benlong(ssnd_size);
	if (lseek(fd, 0L, 0))
	    die("seek error while updating AIFF header");
	if ( write(fd, &form, sizFormHdr) != sizFormHdr
	  || write(fd, &comm1,sizCommChunk1) != sizCommChunk1
	  || write(fd, &comm2,sizCommChunk2) != sizCommChunk2
	  || write(fd, &ssnd, sizSoundDataHdr) != sizSoundDataHdr )
	    die("error while rewriting AIFF header");
}

int is_aiff_form(firstlong)    /* test a long for aiff form ID                 */
  long firstlong;              /* called by readheader prior to aiffReadHeader */
{
        return (firstlong == *(long *)FORM_ID);
}

typedef struct {
  short markerID;
  long  position;
} MARKER;

static LOOPDAT *loopdata = NULL;

void aiffReadHeader(fd,fname,hdr,firstlong,p) /* Read AIFF header, fill hdr, &  */
  int fd;             			      /* postn rd ptr to start of samps */
  char *fname;
  HEADATA *hdr;	/* datablock for passing data back */
  long firstlong;
  SOUNDIN *p;
{
	CkHdr        ckHdr;
        FormHdr      form;
	CommChunk1   comm1;
	CommChunk2   comm2;
	InstrChunk   instr;
	SoundDataHdr ssnd;
	int mark_read = 0, inst_read = 0, loops_read = 0;
	int comm_read = 0, ssnd_read = 0, all_read = 0;
	long ssnd_offset, ssnd_pos, pos, ckSize;
	short sampsize, nmarkers = 0, nn;
	MARKER *markersp, *mp;
	Loop *ilp;
	LOOPDAT *ldp;
	char *err;
	double sr, oct;
extern  double onept, ieee_80_to_double();

	if (!is_aiff_form(firstlong))    /* double check it's a form header */
	    die("bad form for aiffReadHeader");         /* & read remainder */
	sreadin(fd,(char *)&form + sizeof(long),sizeof(FormHdr) - sizeof(long),p);
	if (form.formType != *(long *) FORM_TYPE)
	    die("form header not type aiff");
	hdr->loopdata = NULL;
	hdr->readlong = FALSE;
	hdr->firstlong = 0;
	while (1) {				       /* read in the next header */
	    if (sreadin(fd,&ckHdr,sizeof(CkHdr),p) < sizeof(CkHdr)) {
	        all_read = 1;
		goto chkout;
	    }
	    pos = tell(fd);
	    if (ckHdr.ckID == *(long *) COMM_ID) {	/* CommChunk hdr: rd rem 1 */
		sreadin(fd,(char *)&comm1 + sizeof(CkHdr), sizeof(short), p);
		sreadin(fd,(char *)&comm2, sizCommChunk2, p);   /* + all of part 2 */
		sampsize = natshort(comm2.sampleSize);
		if (sampsize <= 8) {    	/* parse CommonChunk to hdr format */
		    hdr->format = AE_CHAR;
		    hdr->sampsize = sizeof(char);
		}
		else if (sampsize <= 16) {
		    hdr->format = AE_SHORT;
		    hdr->sampsize = sizeof(short);
		}
		else if (sampsize <= 24)
		    die("AIFF 3-byte samples not supported");
		else {
		    hdr->format = AE_LONG;
		    hdr->sampsize = sizeof(long);
		}
		hdr->nchnls = natshort(comm1.numChannels);
		sr = ieee_80_to_double(comm2.sampleRate);  /* decode 80-bit srate */
		hdr->sr = (long) sr;
		comm_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) MARK_ID) { 	/* Markers Chunk: */
	        sreadin(fd,(char *)&nmarkers, sizeof(short), p);
		nmarkers = natshort(nmarkers);
		markersp = (MARKER *) mcalloc((long)sizeof(MARKER) * nmarkers);
		for (nn = nmarkers, mp = markersp; nn--; mp++) {  /* for nmarkers */
		    u_char psiz, pstring[256];              /* read ID/postn pair */
		    sreadin(fd,(char *)&mp->markerID, sizeof(short), p);
		    sreadin(fd,(char *)&mp->position, sizeof(long), p);
		    sreadin(fd,&psiz, 1, p);                /* leave unnatural,   */
		    psiz |= 01;                             /*     & skip pstring */
		    sreadin(fd, pstring, (int)psiz, p);
		}
		if (inst_read == TRUE)
		    goto getloops;
		else mark_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) INST_ID) { 	/* Instr Chunk:  */
	        int subhdrsiz = sizeof(InstrChunk) - sizeof(CkHdr);
	        sreadin(fd,(char *)&instr + sizeof(CkHdr), subhdrsiz, p);
		if (mark_read == TRUE)
		    goto getloops;
		else inst_read = TRUE;
	    }
	    else if (ckHdr.ckID == *(long *) SSND_ID) { 	/* SoundDataHdr: */
	        int subhdrsiz = sizeof(SoundDataHdr) - sizeof(CkHdr);
	        sreadin(fd,(char *)&ssnd + sizeof(CkHdr), subhdrsiz, p);
		ssnd_offset = natlong(ssnd.offset);
		ssnd_pos = pos + subhdrsiz + ssnd_offset;
		hdr->hdrsize = ssnd_pos;
		hdr->typaiff = 1;
		hdr->audsize = natlong(ckHdr.ckSize) - subhdrsiz - ssnd_offset;
		ssnd_read = TRUE;
	    }		   /* if read CommonChunk,SoundDataHdr,Loops, we're done */
  chkout:   if (comm_read && ssnd_read && (loops_read || all_read)) {
		printf("%s: AIFF, %ld%s samples", fname,
		       hdr->audsize/hdr->sampsize/hdr->nchnls,
		       hdr->nchnls == 1 ? "" : " stereo");
		if ((ldp = hdr->loopdata) != NULL) {
		    printf(", baseFrq %4.1f (midi %d)",
			   ldp->natcps,instr.baseNote);
		    printf(", sustnLp: mode %d, %ld to %ld",
			   ldp->loopmode1,ldp->begin1,ldp->end1);
		    printf(", relesLp: mode %d, %ld to %ld\n",
			   ldp->loopmode2,ldp->begin2,ldp->end2);
		}
		else printf(", no looping\n");
	        if (lseek(fd,ssnd_pos,0) != ssnd_pos)
		    die("error seeking to start of sound data");
		return;
	    }
	    ckSize = natlong(ckHdr.ckSize); /* loop: seek past this chunk to next */
	    if (lseek(fd, pos + ckSize, 0) != pos + ckSize)
		die("error while seeking past AIFF chunk");
	    continue;
	                 /* we've got both InstrChunk & Markers.  Find loop info  */
  getloops: if ((ldp = loopdata) == NULL)
	        ldp = loopdata = (LOOPDAT *) mcalloc((long)sizeof(LOOPDAT));
	    oct = (instr.baseNote + instr.detune/100.) / 12. + 3.;
	    ldp->natcps = pow((double)2., oct) * onept;
	    ilp = &instr.sustainLoop;
	    ldp->loopmode1 = natshort(ilp->playMode);
	    for (nn = nmarkers, mp = markersp; nn--; mp++) {
	        if (mp->markerID == ilp->beginLoop)
		    ldp->begin1 = natlong(mp->position);
	        if (mp->markerID == ilp->endLoop)
		    ldp->end1 = natlong(mp->position);
	    }
	    ilp = &instr.releaseLoop;
	    ldp->loopmode2 = ilp->playMode;
	    for (nn = nmarkers, mp = markersp; nn--; mp++) {
	        if (mp->markerID == ilp->beginLoop)
		    ldp->begin2 = natlong(mp->position);
	        if (mp->markerID == ilp->endLoop)
		    ldp->end2 = natlong(mp->position);
	    }
	    free(markersp);
	    err = NULL;
	    if (ldp->natcps <= 0.0)
	        err = "baseNote";
	    if (ldp->loopmode1 < 0 || ldp->loopmode1 > 3)
	        err = "sustain loop playMode";
	    else if (ldp->loopmode1
		  && (ldp->begin1 < 0 || ldp->begin1 >= ldp->end1))
	        err = "sustain loop";
	    else if (ldp->loopmode2 < 0 || ldp->loopmode2 > 3)
	        err = "release loop playMode";
	    else if (ldp->loopmode2
		  && (ldp->begin2 < 0 || ldp->begin2 >= ldp->end2))
		err = "release loop";
	    if (err != NULL) {
	        printf("INFILE ERROR: illegal %s info in aiff file %s\n",err,fname);
		hdr->loopdata = NULL;
	    }
	    else hdr->loopdata = ldp;
	    loops_read = TRUE;
	    goto chkout;
	}
}
